from library.python.monitoring.solo.objects.solomon.sensor import Sensor

from direct.solo.registered.project import projects
from direct.solo.registered.service import services


class MdbSensor(Sensor):
    def __init__(self, **other_labels):
        predefined_labels = dict(project=projects.mdb.id,
                                 service=services.mdb,
                                 cluster='{{cluster}}',
                                 node='{{node}}',
                                 dc='{{dc}}',
                                 host='{{host}}'
                                 )
        for key, value in predefined_labels.items():
            if key not in other_labels:
                other_labels[key] = value
        super().__init__(**other_labels)

    def get_dashboard_link(self, **other_parameters):
        params = dict(
            cs="default",
            stack='false',
        )
        params.update(other_parameters)
        return self.build_sensor_link(parameters=params, full_link=False)


class MdbByHostSensor(MdbSensor):
    def __init__(self, **other_labels):
        other_labels['node'] = 'by_host'
        other_labels['dc'] = 'by_host'
        if 'host' not in other_labels:
            other_labels['host'] = '*'
        super().__init__(**other_labels)


class MdbByNodeSensor(MdbSensor):
    def __init__(self, **other_labels):
        other_labels['dc'] = 'by_node'
        other_labels['host'] = 'by_node'
        super().__init__(**other_labels)


mysql_threads_running = MdbByHostSensor(sensor='mysql_Threads_running')
mysql_threads_connected = MdbByHostSensor(sensor='mysql_Threads_connected')
mysql_replication_lag = MdbByHostSensor(sensor='mysql_replication_lag')
