from library.python.monitoring.solo.objects.solomon.sensor import Sensor

from direct.solo.registered.project import projects
from direct.solo.registered.service.balancer import direct_awacs


class BaseAwacsSensor(Sensor):
    def __init__(self, **other_labels):
        predefined_labels = dict(
            project=projects.direct.id,
            service=direct_awacs.name,
            host='CLUSTER',
        )
        for key, value in predefined_labels.items():
            if key not in other_labels:
                other_labels[key] = value
        super().__init__(**other_labels)


class AwacsRpsSensor(BaseAwacsSensor):
    def __init__(self, **other_labels):
        other_labels['sensor'] = 'report-service_total-requests'
        super().__init__(**other_labels)


class Awacs5xxSensor(BaseAwacsSensor):
    def __init__(self, **other_labels):
        other_labels['sensor'] = 'report-service_total-outgoing_5xx'
        super().__init__(**other_labels)


class ResponseTimeSensor(BaseAwacsSensor):
    def __init__(self, **other_labels):
        other_labels['sensor'] = 'report-service_total-processing_time'
        super().__init__(**other_labels)
