from library.python.monitoring.solo.objects.solomon.sensor import Sensor
from direct.solo.registered.cluster import clusters
from direct.solo.registered.project import projects
from direct.solo.registered.service import services


class BaseQueueSensor(Sensor):
    def __init__(self, **other_labels):
        predefined_labels = dict(project=projects.direct.id,
                                 cluster=clusters.jobs_prod.name,
                                 host='CLUSTER',
                                 env='production')
        for key, value in predefined_labels.items():
            if key not in other_labels:
                other_labels[key] = value
        super().__init__(**other_labels)


class CampaignsCount(BaseQueueSensor):
    def __init__(self, **other_labels):
        other_labels['sensor'] = 'campaigns.count'
        super().__init__(**other_labels)


class ObjectsCount(BaseQueueSensor):
    def __init__(self, **other_labels):
        other_labels['sensor'] = 'objects.count'
        super().__init__(**other_labels)


class ClientsCount(BaseQueueSensor):
    def __init__(self, **other_labels):
        other_labels['sensor'] = 'clients.count'
        super().__init__(**other_labels)


class WorkersCount(BaseQueueSensor):
    def __init__(self, **other_labels):
        other_labels['sensor'] = 'workers.count'
        super().__init__(**other_labels)


class QueueAge(BaseQueueSensor):
    def __init__(self, **other_labels):
        other_labels['sensor'] = 'queue.age_minutes'
        super().__init__(**other_labels)


class SequenceAge(BaseQueueSensor):
    def __init__(self, **other_labels):
        other_labels['sensor'] = 'sequence.age_minutes'
        super().__init__(**other_labels)


BS_EXPORT_CRIT_DELAY = 90     # наш оговоренный SLA, по нему считаем даунтайм
bs_export_campaigns_count=CampaignsCount(service=services.direct_bs_export_queue.name, queue="-", type="export")
bs_export_clients_count=ClientsCount(service=services.direct_bs_export_queue.name, queue="-", type="export")
bs_export_max_queue_age=QueueAge(service=services.direct_bs_export_queue.name, queue="-", type="export")
bs_export_buggy_sequence_age=SequenceAge(service=services.direct_bs_export_queue.name, queue="buggy", type="export")
