from library.python.monitoring.solo.objects.solomon.v2 import Service, SensorConf, AggrRules

from direct.solo.registered.project import projects

# Service used for direct balancers installations in awacs
# Contains L7-balancer stats (currently with legacy stats)
direct_awacs = Service(
    id="direct_l7_balancer",
    name="awacs",
    project_id=projects.direct.id,
    port=82,
    path="/solomon",
    interval=15,
    grid=15,
    sensors_ttl_days=None,
    sensor_conf=SensorConf(
        aggr_rules={
            AggrRules(cond={"host=*"}, target={"host={{DC}}"}),
            AggrRules(cond={"host=*"}, target={"host=CLUSTER"}),
        },
        priority_rules=set(),
        raw_data_mem_only=False),
)

exports = [
    direct_awacs
]
