from library.python.monitoring.solo.objects.solomon.v2 import Service, SensorConf, AggrRules

from direct.solo.registered.project import projects


def build_service(project_id):
    name = "bs-export-queue"
    return Service(
        id="%s_%s" % (project_id, name),
        name=name,
        project_id=project_id,
        port=80,
        path="/monitoring?registry=bs-export-queue-metrics",
        interval=15,
        grid=15,
        sensors_ttl_days=None,
        sensor_conf=SensorConf(
            aggr_rules={
                AggrRules(cond={"host=*"}, target={"host=CLUSTER"}),
            },
            priority_rules=set(),
            raw_data_mem_only=True),
    )


direct_bs_export_queue = build_service(projects.direct.id)
direct_test_bs_export_queue = build_service(projects.direct_test.id)

exports = [
    direct_bs_export_queue,
    direct_test_bs_export_queue
]
