from library.python.monitoring.solo.objects.solomon.v2 import Service, SensorConf, AggrRules

from direct.solo.registered.project import projects


def build_service(project_id):
    name = "external-metrics"
    return Service(
        id="%s_%s" % (project_id, name),
        name=name,
        project_id=project_id,
        port=80,
        path="/external-metrics",   # todo: поменять на /monitoring?registry=external-metrics
        interval=15,
        grid=15,
        sensors_ttl_days=None,
        sensor_conf=SensorConf(
            aggr_rules={
                AggrRules(cond={"host=*"}, target={"host=CLUSTER"}),
            },
            priority_rules=set(),
            raw_data_mem_only=False
        ),
        sensor_name_label="sensor",
    )


prod = build_service(projects.direct.id)
test = build_service(projects.direct_test.id)

exports = [
    prod,
    test,
]
