from library.python.monitoring.solo.objects.solomon.v2 import Service, SensorConf, AggrRules

from direct.solo.registered.project import projects


def build_service(project_id):
    name = "java-monitoring"
    return Service(
        id="%s_%s" % (project_id, name),
        name=name,
        project_id=project_id,
        port=80,
        path="/monitoring",
        interval=15,
        grid=15,
        sensors_ttl_days=None,
        sensor_conf=SensorConf(
            aggr_rules={
                AggrRules(cond={"method=*"}, target={"method=ALL"}),
                AggrRules(cond={"host=*"}, target={"host=CLUSTER"}),
                AggrRules(cond={"method=*", "host=*"}, target={"method=ALL", "host=CLUSTER"}),
            },
            priority_rules=set(),
            raw_data_mem_only=False),
    )


java_monitoring = build_service(projects.direct.id)
test_java_monitoring = build_service(projects.direct_test.id)

exports = [
    java_monitoring,
    test_java_monitoring,
]
