from library.python.monitoring.solo.objects.solomon.v2 import Service, SensorConf, AggrRules

from direct.solo.registered.project import projects


def build_service(project_id):
    name = "nginx-access"
    return Service(
        id="%s_%s" % (project_id, name),
        name=name,
        project_id=project_id,
        port=10931,
        path="/sensors?service=direct_nginx-access",
        interval=60,
        grid=60,
        sensor_conf=SensorConf(
            aggr_rules={
                AggrRules(
                    cond={'sensor=rps', 'response_code=*'},
                    target={'sensor=rps', 'response_code=ALL'},
                ),
                AggrRules(
                    cond={'sensor=rps', 'response_code=*', 'controller=*'},
                    target={'sensor=rps', 'response_code=ALL', 'controller=ALL'},
                ),
                AggrRules(
                    cond={'sensor=rps', 'response_code=*', 'controller=*', 'host=*'},
                    target={'sensor=rps', 'response_code=ALL', 'controller=ALL', 'host=ALL'},
                ),
                AggrRules(
                    cond={'sensor=response_time', 'controller=*'},
                    target={'sensor=response_time', 'controller=ALL'},
                ),
                AggrRules(
                    cond={'sensor=response_time', 'controller=*', 'response_code=*'},
                    target={'sensor=response_time', 'controller=ALL', 'response_code=ALL'},
                ),
                AggrRules(
                    cond={'sensor=response_time', 'controller=*', 'response_code=*', 'host=*'},
                    target={'sensor=response_time', 'controller=ALL', 'response_code=ALL', 'host=ALL'},
                ),
                AggrRules(
                    cond={'sensor=rps', 'controller=*', 'response_code=*', 'host=*'},
                    target={'sensor=rps', 'controller=ALL', 'response_code=ALL', 'host={{DC}}'},
                ),
                AggrRules(
                    cond={'sensor=response_time', 'controller=*', 'response_code=*', 'host=*'},
                    target={'sensor=response_time', 'controller=ALL', 'response_code=ALL', 'host={{DC}}'},
                ),
                AggrRules(
                    cond={'sensor=rps', 'controller=*', 'host=*'},
                    target={'sensor=rps', 'controller=ALL', 'host={{DC}}'},
                ),
                AggrRules(
                    cond={'sensor=response_time', 'controller=*', 'host=*'},
                    target={'sensor=response_time', 'controller=ALL', 'host={{DC}}'},
                ),
            },
            priority_rules=set(),
            raw_data_mem_only=False,
        ),
    )


direct_nginx_access = build_service(projects.direct.id)
direct_test_nginx_access = build_service(projects.direct_test.id)

exports=[
    direct_nginx_access,
    direct_test_nginx_access,
]
