from library.python.monitoring.solo.objects.solomon.v2 import Service

from direct.solo.registered.project import projects


def build_service(project_id):
    name = "trace-pull"
    return Service(
        id="%s_%s" % (project_id, name),
        name=name,
        project_id=project_id,
        port=10186,
        path="/trace-log-functions-metrics",
        interval=15,
        grid=15,
    )


direct_trace_pull_queue = build_service(projects.direct.id)
direct_test_trace_pull_queue = build_service(projects.direct_test.id)

exports = [
    direct_trace_pull_queue,
    direct_test_trace_pull_queue
]
