from library.python.monitoring.solo.objects.solomon.v2 import Service

from direct.solo.registered.project import projects


def build_service(project_id):
    name = "unified_agent"
    port = 16300
    path = "/counters/spack"
    return Service(
        id="%s_%s" % (project_id, name),
        name=name,
        project_id=project_id,
        port=port,
        path=path,
        interval=15,
        grid=15,
    )


direct_unified_agent = build_service(projects.direct.id)
direct_test_unified_agent = build_service(projects.direct_test.id)

exports = [
    direct_unified_agent,
    direct_test_unified_agent
]
