from library.python.monitoring.solo.objects.solomon.v2 import Shard

from direct.solo.registered.cluster import clusters
from direct.solo.registered.project import projects
from direct.solo.registered.service import services


def build_shard(cluster_id):
    return Shard(
        id="%s_l7_balancer" % cluster_id,
        project_id=projects.direct.id,
        cluster_id=cluster_id,
        service_id=services.direct_awacs.id,
        sensor_name_label="",
    )


direct_balancer_api_awacs = build_shard(cluster_id=clusters.direct_api_balancer.id)
direct_balancer_intapi_awacs = build_shard(cluster_id=clusters.direct_intapi_balancer.id)
direct_canvas_awacs = build_shard(cluster_id=clusters.direct_canvas_balancer.id)
direct_balancer_awacs = build_shard(cluster_id=clusters.direct_balancer.id)
direct_pages_awacs = build_shard(cluster_id=clusters.direct_pages_balancer.id)
uac_awacs = build_shard(cluster_id=clusters.uac_balancer.id)

exports = [
    # new shards
    direct_balancer_api_awacs,
    direct_balancer_intapi_awacs,
    direct_canvas_awacs,
    direct_balancer_awacs,
    direct_pages_awacs,
    uac_awacs
]
