from library.python.monitoring.solo.objects.solomon.v2 import Shard

from direct.solo.registered.cluster import clusters
from direct.solo.registered.service import services


def build_shard(cluster, service):
    return Shard(
        id="%s_%s" % (cluster.id, service.name),
        project_id=service.project_id,
        cluster_id=cluster.id,
        service_id=service.id,
        sensor_name_label="",
    )


direct_bs_export_queue = build_shard(clusters.jobs_prod, services.direct_bs_export_queue)
direct_test_bs_export_queue = build_shard(clusters.jobs_test, services.direct_test_bs_export_queue)

exports = [
    direct_bs_export_queue,
    direct_test_bs_export_queue,
]
