from library.python.monitoring.solo.objects.solomon.v2 import Shard

from direct.solo.registered.cluster import clusters
from direct.solo.registered.service import external_metrics as service


def build_shard(cluster, service):
    return Shard(
        id="%s_%s" % (cluster.id, service.name),
        project_id=service.project_id,
        cluster_id=cluster.id,
        service_id=service.id,
        sensor_name_label="",
    )


jobs_prod = build_shard(clusters.jobs_prod, service.prod)
jobs_test = build_shard(clusters.jobs_test, service.test)
intapi_prod = build_shard(clusters.intapi_prod, service.prod)


exports = [
    jobs_prod,
    jobs_test,
    intapi_prod,
]
