from itertools import chain
from library.python.monitoring.solo.objects.solomon.v2 import Shard

import direct.solo.registered.cluster as cluster
from direct.solo.registered.project import projects
from direct.solo.registered.service.grut_object_api import grut_monitoring, test_grut_monitoring

# В кластерах сейчас разброд и шатание, поэтому мы не можем сгенерировать напрямую.
# Вместо этого хардкодим список тестовых кластеров, и откладываем продакшн до лучших времен (DIRECTADMIN-8777)
# api5, oneshot
app_names_with_grut={'app_java-web', 'app_java-intapi', 'app_java-jobs'}


def get_test_clusters():
    return [cluster for cluster in cluster.get_java_clusters() if cluster.project_id == projects.direct_test.id]


def get_production_clusters():
    return [cluster for cluster in cluster.get_java_clusters() if cluster.project_id == projects.direct.id]


def get_grut_apps_clusters(clusters):
    return [cluster for cluster in clusters if cluster.name in app_names_with_grut]


def build_shard(cluster, service):
    return Shard(
        id="%s_%s" % (cluster.id, service.name),
        project_id=service.project_id,
        cluster_id=cluster.id,
        service_id=service.id,
        sensor_name_label="",
    )

exports=list(
    chain(
        (build_shard(cluster, test_grut_monitoring)
         for cluster in get_grut_apps_clusters(get_test_clusters())),
        (build_shard(cluster, grut_monitoring)
         for cluster in get_grut_apps_clusters(get_production_clusters()))
    )
)
