from library.python.monitoring.solo.objects.solomon.v2 import Shard

from direct.solo.registered.cluster.deploy_java_apps import export_java_app_in_deploy_clusters as clusters
from direct.solo.registered.project import projects
from direct.solo.registered.service.unified_agent import direct_unified_agent
from direct.solo.registered.service.unified_agent import direct_test_unified_agent


def build_shard(cluster, service):
    return Shard(
        id="%s_%s" % (cluster.id, service.name),
        project_id=service.project_id,
        cluster_id=cluster.id,
        service_id=service.id,
        sensor_name_label="",
    )

exports = []

for cluster in clusters:
    if cluster.project_id == projects.direct.id:
        exports.append(build_shard(cluster, direct_unified_agent))
    else:
        exports.append(build_shard(cluster, direct_test_unified_agent))
