#!/usr/bin/env bash

set -ex

node -v
pnpm -v

ulimit -n 65536

cat << 'EOF' > $TMP/run_server.sh
#!/usr/bin/env bash

set -ex

MEM_OPTS="-Xmx2G"
JAVA_OPTS="$MEM_OPTS \
    -Dfile.encoding=UTF-8 \
    -Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true \
    -Dsun.net.inetaddr.ttl=60 -Dsun.net.inetaddr.negative.ttl=0 \
    -Djava.util.Arrays.useLegacyMergeSort=true \
    -XX:-UsePerfData \
    -XX:+UseG1GC \
    -XX:MaxGCPauseMillis=100"
JAVA_ARGS="$JAVA_OPTS -cp yandex-direct-web/*: -Djava.library.path=yandex-direct-web ru.yandex.direct.web.DirectWebApp"

cd $TMP

ya tool java11 $JAVA_ARGS 2>&1 | tee -a $RESULT_RESOURCES_PATH/yandex-direct-web.log 1>/dev/null
EOF
chmod +x $TMP/run_server.sh

cat << 'EOF' > $TMP/run_test.sh
#!/usr/bin/env bash

set -ex

# Указываем скриптам 'ci:typecheck' забирать схему из локального бекенда
export DIRECT_GRAPHQL_BASE_URL="https://localhost:8443"

# Проверка типов
cd $ARCADIA_PATH/adv/frontend
pnpm run -r "ci:graphql-types"
pnpm run -r "ci:typecheck-for-backend"
EOF
chmod +x $TMP/run_test.sh

# run jetty-server, then when port 8090 responds run graphql-types tests
npx start-server-and-test "$TMP/run_server.sh" "http://localhost:8090/admin?action=graphql_schema&schema=grid" "${TMP}/run_test.sh"
