package ru.yandex.direct.web;

import org.slf4j.Logger;

import ru.yandex.direct.common.jetty.JettyConfig;
import ru.yandex.direct.common.jetty.JettyLauncher;
import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.config.DirectConfigFactory;
import ru.yandex.direct.jcommander.ParserWithHelp;
import ru.yandex.direct.logging.LoggingInitializer;
import ru.yandex.direct.logging.LoggingInitializerParams;

public class DirectWebApp {
    private static final Logger logger = LoggingInitializer.getLogger(DirectWebApp.class);

    private DirectWebApp() {
    }

    public static void main(String[] args) throws Exception {
        LoggingInitializerParams loggingParams = new LoggingInitializerParams();
        ParserWithHelp.parse(DirectWebApp.class.getCanonicalName(), args, loggingParams);
        LoggingInitializer.initialize(loggingParams, "direct.web");

        DirectConfig conf = DirectConfigFactory.getConfig();
        JettyConfig jettyConfig = new JettyConfig(conf.getBranch("jetty"));

        logger.info("start jetty server with config: {}", jettyConfig);

        JettyLauncher.server(jettyConfig)
                .withDefaultWebApp(DirectWebApp.class.getClassLoader(), "/")
                .run();
    }
}
