package ru.yandex.direct.web;

import java.io.Serializable;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.bundle.TranslationStub;

public interface DirectWebTranslations extends TranslationBundle, Serializable {

    DirectWebTranslations INSTANCE = I18NBundle.implement(DirectWebTranslations.class);

    @MessageFormatStub("При обращении в службу поддержки укажите следующие данные: {0}")
    Translatable supportDataMessage(String data);

    @TranslationStub("Неправильное значение фильтра")
    Translatable invalidFilterValue();

    @MessageFormatStub("Ожидалось: {0}, было получено: {1}")
    Translatable invalidFilterValueDescription(Translatable typeName, Object value);

    @TranslationStub("Число")
    Translatable number();

    @TranslationStub("Список чисел")
    Translatable listOfNumbers();
}
