package ru.yandex.direct.web.common.converter.protojson

import com.fasterxml.jackson.core.JsonGenerator
import com.fasterxml.jackson.databind.JsonSerializer
import com.fasterxml.jackson.databind.SerializerProvider
import com.google.protobuf.Message
import com.google.protobuf.util.JsonFormat

class ProtobufSerializer : JsonSerializer<Message>() {
    companion object {
        private val PRINTER = JsonFormat.printer()
            .omittingInsignificantWhitespace()
            .preservingProtoFieldNames()
    }

    override fun serialize(value: Message?, gen: JsonGenerator?, serializers: SerializerProvider?) {
        gen!!.writeRawValue(PRINTER.print(value))
    }
}
