package ru.yandex.direct.web.configuration;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;
import org.springframework.web.context.annotation.RequestScope;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

import ru.yandex.direct.common.configuration.UacYdbConfiguration;
import ru.yandex.direct.communication.config.CommunicationConfiguration;
import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.core.configuration.CoreConfiguration;
import ru.yandex.direct.core.entity.adgroup.model.TextAdGroup;
import ru.yandex.direct.core.entity.banner.model.BannerPrice;
import ru.yandex.direct.core.entity.banner.model.ContentPromotionBanner;
import ru.yandex.direct.core.entity.banner.model.CpcVideoBanner;
import ru.yandex.direct.core.entity.banner.model.CpmAudioBanner;
import ru.yandex.direct.core.entity.banner.model.CpmBanner;
import ru.yandex.direct.core.entity.banner.model.DynamicBanner;
import ru.yandex.direct.core.entity.banner.model.ImageBanner;
import ru.yandex.direct.core.entity.banner.model.McBanner;
import ru.yandex.direct.core.entity.banner.model.TextBanner;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDemographics;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDemographicsAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDesktop;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDesktopAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierMobile;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierMobileAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierRetargeting;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierRetargetingAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierVideo;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierVideoAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierWeather;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierWeatherAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierWeatherLiteral;
import ru.yandex.direct.core.entity.bidmodifier.ComplexBidModifier;
import ru.yandex.direct.core.entity.campaign.container.DeleteCampMetrikaCountersRequest;
import ru.yandex.direct.core.entity.campaign.container.UpdateCampMetrikaCountersRequest;
import ru.yandex.direct.core.entity.campaign.model.Campaign;
import ru.yandex.direct.core.entity.deal.container.CampaignDeal;
import ru.yandex.direct.core.entity.deal.container.UpdateDealContainer;
import ru.yandex.direct.core.entity.deal.model.Deal;
import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.core.entity.mobileapp.model.MobileApp;
import ru.yandex.direct.core.entity.mobileapp.model.MobileAppTracker;
import ru.yandex.direct.core.entity.relevancematch.model.RelevanceMatch;
import ru.yandex.direct.core.entity.retargeting.container.ReplaceRetargetingConditionGoal;
import ru.yandex.direct.core.entity.retargeting.container.SwitchRetargeting;
import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.model.Rule;
import ru.yandex.direct.core.entity.sitelink.model.Sitelink;
import ru.yandex.direct.core.entity.sitelink.model.SitelinkSet;
import ru.yandex.direct.core.entity.sitelink.turbolanding.model.SitelinkTurboLanding;
import ru.yandex.direct.core.entity.uac.grut.GrutContext;
import ru.yandex.direct.core.entity.uac.grut.RequestScopeGrutContext;
import ru.yandex.direct.core.entity.vcard.model.InstantMessenger;
import ru.yandex.direct.core.entity.vcard.model.Phone;
import ru.yandex.direct.core.entity.vcard.model.PointOnMap;
import ru.yandex.direct.core.entity.vcard.model.Vcard;
import ru.yandex.direct.excel.processing.configuration.ExcelProcessingConfiguration;
import ru.yandex.direct.grid.processing.configuration.GridProcessingConfiguration;
import ru.yandex.direct.integrations.configuration.IntegrationsConfiguration;
import ru.yandex.direct.internaltools.configuration.InternalToolsConfiguration;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.validation.presentation.DefectPresentationRegistry;
import ru.yandex.direct.validation.result.DefaultPathNodeConverterProvider;
import ru.yandex.direct.validation.result.PathNodeConverterProvider;
import ru.yandex.direct.web.core.configuration.SecurityConfiguration;
import ru.yandex.direct.web.core.configuration.WebCoreConfiguration;
import ru.yandex.direct.web.entity.bidmodifier.presentation.BidModifierPathConverters;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;
import ru.yandex.direct.ytcore.spring.YtCoreConfiguration;
import ru.yandex.grut.client.GrutClient;

import static ru.yandex.direct.validation.presentation.DefectPresentationRegistryFactory.strictRegistry;
import static ru.yandex.direct.web.entity.adgroup.presentations.AdGroupDefectPresentations.adGroupDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.adgroup.presentations.AdGroupPathConverters.TEXT_AD_GROUP_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.adgroupadditionaltargeting.presentation.AdGroupAdditionalTargetingDefectPresentations.adGroupAdditionalTargetingDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.agency.presentation.AgencyDefectPresentations.agencyDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.banner.presentations.BannerDefectPresentations.bannerDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.banner.presentations.ContentPromotionBannerPathConverter.CONTENT_PROMOTION_BANNER_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.banner.presentations.CpcVideoBannerPathConverters.CPC_VIDEO_BANNER_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.banner.presentations.CpmAudioBannerPathConverters.CPM_AUDIO_BANNER_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.banner.presentations.CpmBannerPathConverter.CPM_BANNER_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.banner.presentations.DynamicBannerPathConverters.DYNAMIC_BANNER_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.banner.presentations.ImageBannerPathConverters.IMAGE_BANNER_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.banner.presentations.McBannerPathConverters.MC_BANNER_BANNER_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.banner.presentations.TextBannerPathConverter.NEW_BANNER_PRICE_IN_BANNER_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.banner.presentations.TextBannerPathConverter.SITELINK_IN_BANNER_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.banner.presentations.TextBannerPathConverter.SITELINK_SET_IN_BANNER_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.banner.presentations.TextBannerPathConverter.SITELINK_TURBOLANDING_IN_BANNER_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.banner.presentations.TextBannerPathConverter.TEXT_BANNER_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.banner.presentations.TextBannerPathConverter.VCARD_INSTANT_MESSENGER_IN_BANNER_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.banner.presentations.TextBannerPathConverter.VCARD_IN_BANNER_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.banner.presentations.TextBannerPathConverter.VCARD_PHONE_IN_BANNER_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.banner.presentations.TextBannerPathConverter.VCARD_POINT_IN_BANNER_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.bid.presentation.BidDefectPresentations.bidDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.bidmodifier.presentation.BidModifierDefectPresentations.bidModifierDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.callout.presentation.CalloutDefectPresentations.calloutPresentationRegistry;
import static ru.yandex.direct.web.entity.campaign.presentations.CampMetrikaCountersPathConverters.DELETE_CAMP_METRIKA_COUNTERS_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.campaign.presentations.CampMetrikaCountersPathConverters.UPDATE_CAMP_METRIKA_COUNTERS_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.campaign.presentations.CampaignDefectPresentations.campMetrikaCountersDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.campaign.presentations.CampaignDefectPresentations.campaignDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.campaign.presentations.CampaignDefectPresentations.strategyDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.campaign.presentations.CampaignPathConverters.CAMPAIGN_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.creative.presentation.CreativeDefectPresentations.creativeDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.deal.presentations.DealDefectPresentations.dealDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.deal.presentations.DealPathConverters.CAMPAIGN_DEAL_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.deal.presentations.DealPathConverters.DEAL_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.deal.presentations.DealPathConverters.LINK_CAMPAIGNS_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.excel.service.validation.ExcelDefectPresentation.excelDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.feature.presentation.FeatureDefectPresentations.featureDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.feed.presentations.FeedDefectPresentations.feedDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.grants.presentation.GrantsDefectPresentations.grantsDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.internalads.presentation.InternalAdsDefectPresentation.internalAdsDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.internaltools.presentations.InternalToolsDefectPresentations.additionalTargetingsToolsPresentationRegistry;
import static ru.yandex.direct.web.entity.internaltools.presentations.InternalToolsDefectPresentations.bsExportQueueToolsPresentationRegistry;
import static ru.yandex.direct.web.entity.internaltools.presentations.InternalToolsDefectPresentations.oneshotRegistry;
import static ru.yandex.direct.web.entity.internaltools.presentations.InternalToolsDefectPresentations.sendCampaignContentToolPresentationRegistry;
import static ru.yandex.direct.web.entity.inventori.InventoriDefectPresentations.inventoriDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.keyword.presentation.KeywordDefectPresentations.advqPhraseDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.keyword.presentation.KeywordDefectPresentations.keywordDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.keyword.presentation.KeywordDefectPresentations.minusPhraseDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.keyword.presentation.KeywordDefectPresentations.phraseDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.keyword.presentation.KeywordPathConverters.KEYWORD_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.mobilecontent.presentations.MobileAppDefectPresentations.mobileAppDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.mobilecontent.presentations.MobileAppPathConverters.MOBILE_APP_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.mobilecontent.presentations.MobileAppPathConverters.MOBILE_APP_TRACKER_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.offerretargeting.presentation.OfferRetargetingDefectPresentations.offerRetargetingDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.performance.presentation.PerformanceBannerDefectPresentations.performanceBannerDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.pricepackage.presentation.PricePackageDefectPresentations.pricePackagesDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.region.presentation.RegionDefectPresentations.regionDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.relevancematch.presentation.RelevanceMatchDefectPresentations.relevanceMatchDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.relevancematch.presentation.RelevanceMatchPathConverters.RELEVANCE_MATCH_PATH_CONVERTER;
import static ru.yandex.direct.web.entity.retargeting.presentation.RetargetingDefectPresentations.retargetingDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.retargetinglists.presentations.RetargetingPresentations.REPLACE_RETARGETING_CONDITION_GOAL_PRESENTATION;
import static ru.yandex.direct.web.entity.retargetinglists.presentations.RetargetingPresentations.RETARGETING_CONDITION_PRESENTATION;
import static ru.yandex.direct.web.entity.retargetinglists.presentations.RetargetingPresentations.RETARGETING_CONDITION_RULE_PRESENTATION;
import static ru.yandex.direct.web.entity.retargetinglists.presentations.RetargetingPresentations.RETARGETING_GOAL_PRESENTATION;
import static ru.yandex.direct.web.entity.retargetinglists.presentations.RetargetingPresentations.SWITCH_RETARGETING_PRESENTATION;
import static ru.yandex.direct.web.entity.sitelink.presentation.SitelinkDefectPresentations.sitelinkDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.smsauth.presentations.SmsAuthDefectPresentations.smsAuthDefectPresentationRegistry;
import static ru.yandex.direct.web.entity.vcard.presentations.VcardDefectPresentations.vcardDefectPresentationRegistry;
import static ru.yandex.direct.web.validation.CommonDefectPresentations.commonDefectPresentationRegistry;
import static ru.yandex.direct.web.validation.GridDefectPresentations.gridDefectPresentationRegistry;

@Configuration
@ComponentScan(
        basePackages = {
                "ru.yandex.direct.web.admin",
                "ru.yandex.direct.web.core.admin",
                "ru.yandex.direct.web.core.exception",
                "ru.yandex.direct.web.entity",
                "ru.yandex.direct.web.validation",
        },
        excludeFilters = @ComponentScan.Filter(value = Configuration.class, type = FilterType.ANNOTATION)
)
@Import({
        CoreConfiguration.class,
        IntegrationsConfiguration.class,
        WebCoreConfiguration.class,
        SecurityConfiguration.class,
        UserActionLogConfiguration.class,
        InternalToolsConfiguration.class,
        GridProcessingConfiguration.class,
        YtCoreConfiguration.class,
        ExcelProcessingConfiguration.class,
        UacYdbConfiguration.class,
        CommunicationConfiguration.class
})
public class DirectWebConfiguration {

    @Bean
    public DefectPresentationRegistry<TranslatableWebDefect> defectPresentationService() {
        DefaultDefectPresentationRegistry<TranslatableWebDefect> generalRegistry =
                DefaultDefectPresentationRegistry.builder()
                        .register(commonDefectPresentationRegistry())
                        .register(gridDefectPresentationRegistry())

                        .register(agencyDefectPresentationRegistry())

                        .register(campaignDefectPresentationRegistry())
                        .register(campMetrikaCountersDefectPresentationRegistry())
                        .register(strategyDefectPresentationRegistry())

                        .register(adGroupDefectPresentationRegistry())
                        .register(feedDefectPresentationRegistry())
                        .register(adGroupAdditionalTargetingDefectPresentationRegistry())
                        .register(regionDefectPresentationRegistry())

                        .register(bidModifierDefectPresentationRegistry())

                        .register(keywordDefectPresentationRegistry())
                        .register(phraseDefectPresentationRegistry())
                        .register(advqPhraseDefectPresentationRegistry())
                        .register(minusPhraseDefectPresentationRegistry())

                        .register(relevanceMatchDefectPresentationRegistry())
                        .register(offerRetargetingDefectPresentationRegistry())

                        .register(retargetingDefectPresentationRegistry())

                        .register(bidDefectPresentationRegistry())

                        .register(bannerDefectPresentationRegistry())
                        .register(calloutPresentationRegistry())
                        .register(sitelinkDefectPresentationRegistry())
                        .register(vcardDefectPresentationRegistry())

                        .register(creativeDefectPresentationRegistry())

                        .register(dealDefectPresentationRegistry())

                        .register(grantsDefectPresentationRegistry())
                        .register(mobileAppDefectPresentationRegistry())
                        .register(featureDefectPresentationRegistry())
                        .register(inventoriDefectPresentationRegistry())
                        .register(bsExportQueueToolsPresentationRegistry())
                        .register(sendCampaignContentToolPresentationRegistry())
                        .register(additionalTargetingsToolsPresentationRegistry())
                        .register(oneshotRegistry())
                        .register(internalAdsDefectPresentationRegistry())
                        .register(performanceBannerDefectPresentationRegistry())
                        .register(pricePackagesDefectPresentationRegistry())
                        .register(smsAuthDefectPresentationRegistry())
                        .register(excelDefectPresentationRegistry())
                        .build();

        // кидаем исключение, если презентация не найдена
        return strictRegistry(generalRegistry);
    }

    @Bean
    public PathNodeConverterProvider defaultWebPathNodeConverterProvider() {
        return DefaultPathNodeConverterProvider.builder()
                .register(Campaign.class, CAMPAIGN_PATH_CONVERTER)
                .register(TextAdGroup.class, TEXT_AD_GROUP_PATH_CONVERTER)
                .register(Keyword.class, KEYWORD_PATH_CONVERTER)
                .register(RelevanceMatch.class, RELEVANCE_MATCH_PATH_CONVERTER)

                .register(ComplexBidModifier.class,
                        BidModifierPathConverters.COMPLEX_BID_MODIFIER_PATH_CONVERTER)
                .register(BidModifierRetargeting.class,
                        BidModifierPathConverters.RETARGETING_BID_MODIFIER_PATH_CONVERTER)
                .register(BidModifierRetargetingAdjustment.class,
                        BidModifierPathConverters.RETARGETING_ADJUSTMENT_PATH_CONVERTER)
                .register(BidModifierDemographics.class,
                        BidModifierPathConverters.DEMOGRAPHY_BID_MODIFIER_PATH_CONVERTER)
                .register(BidModifierDemographicsAdjustment.class,
                        BidModifierPathConverters.DEMOGRAPHY_ADJUSTMENT_PATH_CONVERTER)
                .register(BidModifierVideo.class,
                        BidModifierPathConverters.VIDEO_BID_MODIFIER_PATH_CONVERTER)
                .register(BidModifierVideoAdjustment.class,
                        BidModifierPathConverters.VIDEO_ADJUSTMENT_PATH_CONVERTER)
                .register(BidModifierMobile.class,
                        BidModifierPathConverters.MOBILE_BID_MODIFIER_PATH_CONVERTER)
                .register(BidModifierMobileAdjustment.class,
                        BidModifierPathConverters.MOBILE_ADJUSTMENT_PATH_CONVERTER)
                .register(BidModifierDesktop.class,
                        BidModifierPathConverters.DESKTOP_BID_MODIFIER_PATH_CONVERTER)
                .register(BidModifierDesktopAdjustment.class,
                        BidModifierPathConverters.DESKTOP_ADJUSTMENT_PATH_CONVERTER)
                .register(BidModifierWeather.class,
                        BidModifierPathConverters.WEATHER_BID_MODIFIER_PATH_CONVERTER)
                .register(BidModifierWeatherAdjustment.class,
                        BidModifierPathConverters.WEATHER_ADJUSTMENT_PATH_CONVERTER)
                .register(BidModifierWeatherLiteral.class,
                        BidModifierPathConverters.WEATHER_LITERAL_PATH_CONVERTER)


                .register(SitelinkSet.class, SITELINK_SET_IN_BANNER_PATH_CONVERTER)
                .register(Sitelink.class, SITELINK_IN_BANNER_PATH_CONVERTER)
                .register(SitelinkTurboLanding.class, SITELINK_TURBOLANDING_IN_BANNER_PATH_CONVERTER)
                .register(Vcard.class, VCARD_IN_BANNER_PATH_CONVERTER)
                .register(Phone.class, VCARD_PHONE_IN_BANNER_PATH_CONVERTER)
                .register(InstantMessenger.class, VCARD_INSTANT_MESSENGER_IN_BANNER_PATH_CONVERTER)
                .register(PointOnMap.class, VCARD_POINT_IN_BANNER_PATH_CONVERTER)
                .register(BannerPrice.class, NEW_BANNER_PRICE_IN_BANNER_PATH_CONVERTER)

                .register(TextBanner.class, TEXT_BANNER_PATH_CONVERTER)
                .register(ContentPromotionBanner.class, CONTENT_PROMOTION_BANNER_PATH_CONVERTER)
                .register(ImageBanner.class, IMAGE_BANNER_PATH_CONVERTER)
                .register(CpcVideoBanner.class, CPC_VIDEO_BANNER_PATH_CONVERTER)
                .register(CpmBanner.class, CPM_BANNER_PATH_CONVERTER)
                .register(McBanner.class, MC_BANNER_BANNER_PATH_CONVERTER)
                .register(CpmAudioBanner.class, CPM_AUDIO_BANNER_PATH_CONVERTER)
                .register(DynamicBanner.class, DYNAMIC_BANNER_PATH_CONVERTER)

                .register(RetargetingCondition.class, RETARGETING_CONDITION_PRESENTATION)
                .register(Rule.class, RETARGETING_CONDITION_RULE_PRESENTATION)
                .register(Goal.class, RETARGETING_GOAL_PRESENTATION)
                .register(ReplaceRetargetingConditionGoal.class, REPLACE_RETARGETING_CONDITION_GOAL_PRESENTATION)
                .register(SwitchRetargeting.class, SWITCH_RETARGETING_PRESENTATION)

                .register(UpdateCampMetrikaCountersRequest.class, UPDATE_CAMP_METRIKA_COUNTERS_PATH_CONVERTER)
                .register(DeleteCampMetrikaCountersRequest.class, DELETE_CAMP_METRIKA_COUNTERS_PATH_CONVERTER)
                .register(Deal.class, DEAL_PATH_CONVERTER)
                .register(UpdateDealContainer.class, LINK_CAMPAIGNS_PATH_CONVERTER)
                .register(CampaignDeal.class, CAMPAIGN_DEAL_PATH_CONVERTER)
                .register(MobileApp.class, MOBILE_APP_PATH_CONVERTER)
                .register(MobileAppTracker.class, MOBILE_APP_TRACKER_PATH_CONVERTER)
                .build();
    }

    @Bean
    public CommonsMultipartResolver multipartResolver(DirectConfig conf) {
        DirectConfig multipartConfig = conf.getBranch("multipart_config");
        CommonsMultipartResolver resolver = new CommonsMultipartResolver();
        resolver.setDefaultEncoding(multipartConfig.getString("default_encoding"));
        resolver.setMaxUploadSize(multipartConfig.getLong("max_upload_size"));
        resolver.setMaxUploadSizePerFile(multipartConfig.getLong("max_upload_size_per_file"));
        return resolver;
    }

    @Bean
    @RequestScope
    public GrutContext grutContext(GrutClient grutClient) {
        return new RequestScopeGrutContext(grutClient);
    }
}
