package ru.yandex.direct.web.configuration;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.common.configuration.CommonConfiguration;
import ru.yandex.direct.config.EssentialConfiguration;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.libs.graphql.GraphqlHelper;

@Configuration
@Import(value = {EssentialConfiguration.class, CommonConfiguration.class})
public class GraphqlConfiguration {
    @Bean
    GraphqlHelper graphqlHelper(EnvironmentType environmentType, TranslationService translationService) {
        return new GraphqlHelper(environmentType, translationService);
    }
}
