package ru.yandex.direct.web.entity;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.web.core.model.WebSuccessResponse;
import ru.yandex.direct.web.validation.model.WebValidationResult;

public abstract class MassResponse<T> extends WebSuccessResponse {
    private T result;
    private WebValidationResult webValidationResult;

    @JsonGetter("result")
    public T getResult() {
        return result;
    }

    @JsonProperty("validation_result")
    public WebValidationResult validationResult() {
        return webValidationResult;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public void setWebValidationResult(WebValidationResult webValidationResult) {
        this.webValidationResult = webValidationResult;
    }

    public <R extends MassResponse<T>> R withResult(T result) {
        setResult(result);
        //noinspection unchecked
        return (R) this;
    }

    public <R extends MassResponse<T>> R withValidation(WebValidationResult validationResult) {
        setWebValidationResult(validationResult);
        //noinspection unchecked
        return (R) this;
    }
}
