package ru.yandex.direct.web.entity;

import com.fasterxml.jackson.annotation.JsonGetter;

import ru.yandex.direct.web.core.model.WebSuccessResponse;

public abstract class SuccessResponse<T> extends WebSuccessResponse {
    private T result;

    public SuccessResponse() {
    }

    public SuccessResponse(T result) {
        this.result = result;
    }

    @JsonGetter("result")
    public T getResult() {
        return result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public <R extends SuccessResponse<T>> R withResult(T result) {
        setResult(result);
        //noinspection unchecked
        return (R) this;
    }
}
