package ru.yandex.direct.web.entity.actreport.controller

import io.swagger.annotations.Api
import io.swagger.annotations.ApiOperation
import org.springframework.format.annotation.DateTimeFormat
import org.springframework.http.HttpHeaders.CONTENT_DISPOSITION
import org.springframework.http.HttpHeaders.CONTENT_TYPE
import org.springframework.stereotype.Controller
import org.springframework.web.bind.annotation.GetMapping
import org.springframework.web.bind.annotation.RequestMapping
import org.springframework.web.bind.annotation.RequestParam
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead
import ru.yandex.direct.web.core.security.DirectWebAuthenticationSource
import ru.yandex.direct.web.core.security.authentication.DirectCookieAuthProvider.PARAMETER_ULOGIN
import ru.yandex.direct.web.entity.actreport.service.ActReportService
import ru.yandex.direct.web.entity.excel.service.validation.ExcelConstraints.XLS_CONTENT_TYPE
import java.time.LocalDate
import javax.servlet.http.HttpServletResponse

@Api
@Controller
@RequestMapping("/act_report")
class ActReportController(
    private val actReportService: ActReportService,
    private val authenticationSource: DirectWebAuthenticationSource
) {
    @ApiOperation(
        value = "Построить отчет по актированным событиям",
        httpMethod = "GET",
        nickname = "act_report"
    )
    @PreAuthorizeRead
    @GetMapping
    fun getActReport(
        @RequestParam(PARAMETER_ULOGIN, required = false) login: String?,
        @RequestParam("date_from", required = false)
        @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
        dateFrom: LocalDate?,
        @RequestParam("date_to", required = false)
        @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
        dateTo: LocalDate?,
        response: HttpServletResponse
    ) {
        val client = authenticationSource.authentication.subjectUser
        val report = actReportService.createReport(client.clientId, dateFrom, dateTo)
        response.apply {
            setHeader(CONTENT_TYPE, XLS_CONTENT_TYPE)
            setHeader(CONTENT_DISPOSITION,
                "attachment; filename=act-report-${client.login}-${report.dateFrom}-${report.dateTo}.xlsx")
            report.workbook.write(outputStream)
        }
    }
}
