package ru.yandex.direct.web.entity.actreport.converter

import ru.yandex.direct.excel.processing.model.actreport.ActReportExcelExportData
import ru.yandex.direct.ytcomponents.statistics.model.ActMoneyStat
import java.time.LocalDateTime
import java.time.ZoneOffset

fun ActReportExcelExportData.Companion.fromActMoneyStat(stat: ActMoneyStat): ActReportExcelExportData {
    return ActReportExcelExportData(
        cid = stat.cid,
        date = LocalDateTime.ofEpochSecond(stat.timestamp, 0, ZoneOffset.UTC).toLocalDate().toString(),
        shows = stat.shows,
        clicks = stat.clicks,
        conversions = stat.conversions,
        total = stat.total,
        money = stat.money,
        bonus = stat.bonus,
        promo = stat.promo,
        sales = stat.sales,
        certs = stat.certs,
        backs = stat.backs
    )
}
