package ru.yandex.direct.web.entity.actreport.service

import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.campaign.service.CampaignService
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.excel.processing.model.actreport.ActReportExcelExportData
import ru.yandex.direct.excel.processing.service.actreport.ActReportExcelExportService
import ru.yandex.direct.web.entity.actreport.converter.fromActMoneyStat
import ru.yandex.direct.web.entity.actreport.model.ActExcelReport
import ru.yandex.direct.ytcomponents.statistics.model.ActMoneyStat
import ru.yandex.direct.ytcore.entity.statistics.service.ActMoneyStatisticsService
import java.time.LocalDate
import java.time.ZoneOffset

@Service
class ActReportService(
    private val campaignService: CampaignService,
    private val actMoneyStatisticsService: ActMoneyStatisticsService,
    private val actReportExcelExportService: ActReportExcelExportService
) {
    fun createReport(clientId: ClientId, dateFrom: LocalDate?, dateTo: LocalDate?): ActExcelReport {
        // по дефолту берем статистику за текущий месяц
        val to = dateTo ?: LocalDate.now()
        val from = dateFrom ?: to.withDayOfMonth(1)
        val campaignIds = campaignService.getClientCampaignIds(clientId)
        val report = actMoneyStatisticsService
            .getActStatistics(
                campaignIds,
                from.atStartOfDay().toEpochSecond(ZoneOffset.UTC), to.atStartOfDay().toEpochSecond(ZoneOffset.UTC)
            )
            .asSequence()
            .sortedWith(compareBy<ActMoneyStat> { it.timestamp }.thenBy { it.cid })
            .map { ActReportExcelExportData.fromActMoneyStat(it) }
            .toList()
            .let { actReportExcelExportService.createReport(it) }
        return ActExcelReport(report, from, to)
    }
}
