package ru.yandex.direct.web.entity.adgeneration.model.apply;

import java.util.List;

import javax.annotation.Nullable;

import ru.yandex.direct.web.entity.adgeneration.model.response.WebGenerateCustomTextResult;
import ru.yandex.direct.web.entity.adgeneration.model.response.WebGenerateTextResult;
import ru.yandex.direct.web.entity.adgeneration.model.response.WebGenerateTextSuggestionsResult;

import static java.util.Collections.emptyList;
import static java.util.Collections.singletonList;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class ApplyTextGeneration {

    @Nullable
    private Long saveReqId;
    @Nullable
    private Long bannerId;
    @Nullable
    private Long adGroupId;
    @Nullable
    private Long campaignId;
    @Nullable
    private Boolean textSingle;
    @Nullable
    private Boolean newCampaign;
    @Nullable
    private List<WebGenerateTextResult> generationResponses;
    @Nullable
    private List<WebGenerateTextSuggestionsResult> suggestionsGenerationResponses;
    @Nullable
    private List<WebGenerateCustomTextResult> suggestionsGenerationByAdSubjectResponses;
    @Nullable
    private String savedTitle;
    @Nullable
    private List<String> savedTitles;
    @Nullable
    private String savedSnippet;
    @Nullable
    private List<String> savedSnippets;

    @Nullable
    public Long getSaveReqId() {
        return saveReqId;
    }

    @Nullable
    public Long getBannerId() {
        return bannerId;
    }

    @Nullable
    public Long getAdGroupId() {
        return adGroupId;
    }

    @Nullable
    public Long getCampaignId() {
        return campaignId;
    }

    @Nullable
    public Boolean getTextSingle() {
        return textSingle;
    }

    @Nullable
    public boolean getNewCampaign() {
        return newCampaign;
    }

    @Nullable
    public List<WebGenerateTextResult> getGenerationResponses() {
        return generationResponses;
    }

    @Nullable
    public List<WebGenerateTextSuggestionsResult> getSuggestionsGenerationResponses() {
        return suggestionsGenerationResponses;
    }

    @Nullable
    public List<WebGenerateCustomTextResult> getSuggestionsGenerationByAdSubjectResponses() {
        return suggestionsGenerationByAdSubjectResponses;
    }

    @Nullable
    public String getSavedTitle() {
        return savedTitle;
    }

    @Nullable
    public String getSavedSnippet() {
        return savedSnippet;
    }

    @Nullable
    public List<String> getSavedTitles() {
        return savedTitles;
    }

    @Nullable
    public List<String> getSavedSnippets() {
        return savedSnippets;
    }

    public ApplyTextGeneration withDefaults() {
        textSingle = textSingle == null || textSingle;
        newCampaign = newCampaign == null || newCampaign;
        //Пока на фронтенде в профи-интерфейсе не будет поддержано логирование мульти-саджестов, перемещаем
        //старые поля одиночных саджестов в новые
        if (textSingle && savedTitles == null && savedSnippets == null && suggestionsGenerationResponses == null) {
            this.savedSnippets = savedSnippet == null ? emptyList() : singletonList(savedSnippet);
            savedSnippet = null;
            this.savedTitles = savedTitle == null ? emptyList() : singletonList(savedTitle);
            savedTitle = null;
            this.suggestionsGenerationResponses =
                    mapList(generationResponses, WebGenerateTextSuggestionsResult::fromWebGenerateTextResult);
            this.generationResponses = null;
        }
        return this;
    }
}
