package ru.yandex.direct.web.entity.adgeneration.model.response;

import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;

import static java.util.Collections.emptyList;
import static java.util.Collections.singletonList;

public class WebGenerateTextSuggestionsResult extends WebGenerationResult {

    @Nullable
    private List<String> titles;

    @Nullable
    private List<String> bodies;

    @Nullable
    private String previewTitle;

    public WebGenerateTextSuggestionsResult() {
    }

    public WebGenerateTextSuggestionsResult(
            String previewTitle,
            List<String> titles,
            List<String> bodies,
            Map<String, Object> additionalInfo) {
        super(additionalInfo);
        this.previewTitle = previewTitle;
        this.titles = titles;
        this.bodies = bodies;
    }

    @Nullable
    public String getPreviewTitle() {
        return previewTitle;
    }

    @Nullable
    public List<String> getTitles() {
        return titles;
    }

    @Nullable
    public List<String> getBodies() {
        return bodies;
    }

    public static WebGenerateTextSuggestionsResult fromWebGenerateTextResult(WebGenerateTextResult result) {
        if (result == null) {
            return null;
        }
        List<String> singleTitleList = result.getTitle() == null ? emptyList() : singletonList(result.getTitle());
        List<String> singleSnippetList = result.getSnippet() == null ? emptyList() : singletonList(result.getSnippet());
        return new WebGenerateTextSuggestionsResult(
                result.getTitle(),
                singleTitleList,
                singleSnippetList,
                result.getAdditionalInfo());
    }
}
