package ru.yandex.direct.web.entity.adgroup.controller;

import javax.annotation.ParametersAreNonnullByDefault;

import static ru.yandex.direct.core.entity.banner.type.href.BannerWithHrefConstraints.domainMatchesAllowedPattern;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.StringConstraints.notEmpty2;

@ParametersAreNonnullByDefault
public class AdGroupControllerUtils {

    /**
     * Проверяет домен на валидноcть, при невалидности выбрасывается исключение {@link IllegalArgumentException}.
     *
     * @throws IllegalArgumentException если запрос не валиден
     */
    public static void validateDomainWithException(String domain) throws IllegalArgumentException {
        if (notNull().apply(domain) != null) {
            throw new IllegalArgumentException("Domain should not be null");
        } else if (notEmpty2().apply(domain) != null) {
            throw new IllegalArgumentException("Domain should not be empty");
        } else if (domainMatchesAllowedPattern().apply(domain) != null) {
            throw new IllegalArgumentException("Incorrect domain");
        }
    }

}
