package ru.yandex.direct.web.entity.adgroup.converter;

import ru.yandex.direct.core.entity.bidmodifier.ComplexBidModifier;
import ru.yandex.direct.web.entity.adgroup.model.WebAdGroupBidModifiers;
import ru.yandex.direct.web.entity.bidmodifier.converter.ExpressionBidModifierConverter;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.web.entity.bidmodifier.converter.DemographicsBidModifierConverter.webDemographicsBidModifierToCore;
import static ru.yandex.direct.web.entity.bidmodifier.converter.MobileBidModifierConverter.webMobileBidModifierToCore;
import static ru.yandex.direct.web.entity.bidmodifier.converter.RetargetingBidModifierConverter.webRetargetingBidModifierToCore;
import static ru.yandex.direct.web.entity.bidmodifier.converter.SimpleBidModifierConverters.webDesktopBidModifierToCore;
import static ru.yandex.direct.web.entity.bidmodifier.converter.SimpleBidModifierConverters.webDesktopOnlyBidModifierToCore;
import static ru.yandex.direct.web.entity.bidmodifier.converter.SimpleBidModifierConverters.webSmartTVBidModifierToCore;
import static ru.yandex.direct.web.entity.bidmodifier.converter.SimpleBidModifierConverters.webVideoBidModifierToCore;
import static ru.yandex.direct.web.entity.bidmodifier.converter.TabletBidModifierConverter.webTabletBidModifierToCore;
import static ru.yandex.direct.web.entity.bidmodifier.converter.WeatherBidModifierConverter.webWeatherBidModifierToCore;

public class AdGroupBidModifiersConverter {

    private AdGroupBidModifiersConverter() {
    }

    public static ComplexBidModifier webAdGroupBidModifiersToCore(WebAdGroupBidModifiers webBidModifiers) {
        if (webBidModifiers == null ||
                (webBidModifiers.getRetargetingBidModifier() == null &&
                        webBidModifiers.getDemographicsBidModifier() == null &&
                        webBidModifiers.getMobileBidModifier() == null &&
                        webBidModifiers.getDesktopBidModifier() == null &&
                        webBidModifiers.getTabletBidModifier() == null &&
                        webBidModifiers.getDesktopOnlyBidModifier() == null &&
                        webBidModifiers.getSmartTVBidModifier() == null &&
                        webBidModifiers.getVideoBidModifier() == null &&
                        webBidModifiers.getWeatherBidModifier() == null &&
                        (webBidModifiers.getExpressionBidModifiers() == null ||
                                webBidModifiers.getExpressionBidModifiers().isEmpty()
                        )
                )
        ) {
            return null;
        }

        return new ComplexBidModifier()
                .withRetargetingModifier(
                        webRetargetingBidModifierToCore(webBidModifiers.getRetargetingBidModifier()))
                .withDemographyModifier(
                        webDemographicsBidModifierToCore(webBidModifiers.getDemographicsBidModifier()))
                .withMobileModifier(webMobileBidModifierToCore(webBidModifiers.getMobileBidModifier()))
                .withDesktopModifier(webDesktopBidModifierToCore(webBidModifiers.getDesktopBidModifier()))
                .withTabletModifier(webTabletBidModifierToCore(webBidModifiers.getTabletBidModifier()))
                .withDesktopOnlyModifier(webDesktopOnlyBidModifierToCore(webBidModifiers.getDesktopOnlyBidModifier()))
                .withSmartTVModifier(webSmartTVBidModifierToCore(webBidModifiers.getSmartTVBidModifier()))
                .withVideoModifier(webVideoBidModifierToCore(webBidModifiers.getVideoBidModifier()))
                .withWeatherModifier(webWeatherBidModifierToCore(webBidModifiers.getWeatherBidModifier()))
                .withExpressionModifiers(mapList(webBidModifiers.getExpressionBidModifiers(),
                        ExpressionBidModifierConverter::webExpressionBidModifierToCore
                ));
    }
}
