package ru.yandex.direct.web.entity.adgroup.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.PageBlock;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.dbschema.ppc.enums.PhrasesAdgroupType;
import ru.yandex.direct.web.entity.adgroup.model.WebCpmAdGroup;
import ru.yandex.direct.web.entity.adgroup.model.WebPageBlock;

import static java.lang.String.format;
import static org.apache.commons.lang3.StringUtils.isEmpty;
import static org.apache.commons.lang3.StringUtils.split;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class AdGroupConverterUtils {

    public static AdGroupType extractCpmAdGroupType(WebCpmAdGroup webCpmAdGroup, CampaignType campaignType) {
        if (campaignType == CampaignType.CPM_DEALS) {
            return AdGroupType.CPM_BANNER;
        }
        if (campaignType == CampaignType.CPM_YNDX_FRONTPAGE) {
            return AdGroupType.CPM_YNDX_FRONTPAGE;
        }
        String type = webCpmAdGroup.getCpmBannersType();
        if (PhrasesAdgroupType.cpm_banner.getLiteral().equals(type)) {
            return AdGroupType.CPM_BANNER;
        } else if (PhrasesAdgroupType.cpm_video.getLiteral().equals(type)) {
            return AdGroupType.CPM_VIDEO;
        } else if (PhrasesAdgroupType.cpm_outdoor.getLiteral().equals(type)) {
            return AdGroupType.CPM_OUTDOOR;
        } else if (PhrasesAdgroupType.cpm_indoor.getLiteral().equals(type)) {
            return AdGroupType.CPM_INDOOR;
        } else if (PhrasesAdgroupType.cpm_audio.getLiteral().equals(type)) {
            return AdGroupType.CPM_AUDIO;
        } else if (PhrasesAdgroupType.cpm_geoproduct.getLiteral().equals(type)) {
            return AdGroupType.CPM_GEOPRODUCT;
        } else if (PhrasesAdgroupType.cpm_geo_pin.getLiteral().equals(type)) {
            return AdGroupType.CPM_GEO_PIN;
        } else {
            throw new UnsupportedOperationException(format("Unsupported ad group type: %s", type));
        }
    }

    public static List<Long> convertGeo(String geo) {
        return isEmpty(geo) ? null : StreamEx.of(split(geo, ","))
                .map(String::trim)
                .map(Long::valueOf)
                .toList();
    }

    public static List<Long> convertTags(Map<String, Integer> tags) {
        if (tags == null) {
            return null;
        }
        return EntryStream.of(tags)
                .filterValues(flag -> Integer.valueOf(1).equals(flag))
                .keys()
                .map(Long::valueOf)
                .toList();
    }

    public static List<String> convertMinusKeywords(WebCpmAdGroup webAdGroup) {
        return webAdGroup.getMinusKeywords() != null ? webAdGroup.getMinusKeywords() : new ArrayList<>();
    }

    public static List<PageBlock> convertPageBlocks(List<WebPageBlock> pageBlocks) {
        return mapList(pageBlocks, pageBlock -> new PageBlock()
                .withPageId(pageBlock.getPageId())
                .withImpId(pageBlock.getImpId()));
    }
}
