package ru.yandex.direct.web.entity.adgroup.converter;

import java.util.List;

import ru.yandex.direct.core.entity.relevancematch.model.RelevanceMatch;
import ru.yandex.direct.web.entity.adgroup.model.WebAdGroupRelevanceMatch;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class RelevanceMatchConverter {

    public static List<RelevanceMatch> webRelevanceMatchesToCore(List<WebAdGroupRelevanceMatch> webRelevanceMatches) {
        return mapList(webRelevanceMatches, RelevanceMatchConverter::webRelevanceMatchToCore);
    }

    public static RelevanceMatch webRelevanceMatchToCore(WebAdGroupRelevanceMatch webRelevanceMatch) {
        if (webRelevanceMatch == null) {
            return null;
        }

        Long id = webRelevanceMatch.getId() != null && !webRelevanceMatch.getId().equals(0L) ?
                webRelevanceMatch.getId() : null;
        return new RelevanceMatch().withId(id);
    }
}
