package ru.yandex.direct.web.entity.adgroup.converter;

import java.util.List;

import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingConditionBase;
import ru.yandex.direct.core.entity.retargeting.model.Rule;
import ru.yandex.direct.core.entity.retargeting.model.TargetInterest;
import ru.yandex.direct.web.core.model.retargeting.CryptaInterestTypeWeb;
import ru.yandex.direct.web.entity.adgroup.model.WebAdGroupRetargeting;
import ru.yandex.direct.web.entity.adgroup.model.WebCpmAdGroupRetargeting;
import ru.yandex.direct.web.entity.adgroup.model.WebRetargetingGoal;
import ru.yandex.direct.web.entity.adgroup.model.WebRetargetingRule;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.utils.NumberUtils.nullIfZero;

public class RetargetingConverter {

    public static List<TargetInterest> webRetargetingsToCore(List<WebAdGroupRetargeting> webAdGroupRetargetings) {
        return mapList(webAdGroupRetargetings, RetargetingConverter::webRetargetingToCore);
    }

    private static TargetInterest webRetargetingToCore(WebAdGroupRetargeting webAdGroupRetargeting) {
        return webAdGroupRetargeting == null ? null : new TargetInterest()
                .withId(nullIfZero(webAdGroupRetargeting.getId()))
                .withRetargetingConditionId(webAdGroupRetargeting.getRetargetingConditionId());
    }

    public static List<TargetInterest> webCpmRetargetingsToCore(List<WebCpmAdGroupRetargeting> webAdGroupRetargetings) {
        return mapList(webAdGroupRetargetings, RetargetingConverter::webCpmRetargetingToCore);
    }

    public static TargetInterest webCpmRetargetingToCore(WebCpmAdGroupRetargeting webAdGroupRetargeting) {
        return webAdGroupRetargeting == null ? null : new TargetInterest()
                .withId(nullIfZero(webAdGroupRetargeting.getId()))
                .withRetargetingConditionId(webAdGroupRetargeting.getRetargetingConditionId());
    }

    public static List<RetargetingCondition> webCpmRetargetingsToCoreRetargetingConditions(
            List<WebCpmAdGroupRetargeting> webAdGroupRetargetings) {
        return mapList(webAdGroupRetargetings, RetargetingConverter::webCpmRetargetingToCoreRetargetingCondition);
    }

    public static List<RetargetingConditionBase> webCpmRetargetingsToCoreRetargetingConditionsBase(
            List<WebCpmAdGroupRetargeting> webAdGroupRetargetings) {
        return mapList(webAdGroupRetargetings, RetargetingConverter::webCpmRetargetingToCoreRetargetingCondition);
    }

    public static RetargetingCondition webCpmRetargetingToCoreRetargetingCondition(
            WebCpmAdGroupRetargeting webAdGroupRetargeting) {
        return webAdGroupRetargeting == null ? null : (RetargetingCondition) new RetargetingCondition()
                .withId(webAdGroupRetargeting.getRetargetingConditionId())
                .withName(webAdGroupRetargeting.getName())
                .withDescription(webAdGroupRetargeting.getDescription())
                .withType(webAdGroupRetargeting.getConditionType())
                .withRules(mapList(webAdGroupRetargeting.getGroups(), RetargetingConverter::webRetargetingRuleToCore));
    }

    private static Rule webRetargetingRuleToCore(WebRetargetingRule webRetargetingRule) {
        return webRetargetingRule == null ? null : new Rule()
                .withType(webRetargetingRule.getRuleType())
                .withInterestType(ifNotNull(webRetargetingRule.getInterestType(), CryptaInterestTypeWeb::toCoreType))
                .withGoals(mapList(webRetargetingRule.getGoals(), RetargetingConverter::webRetargetingGoalToCore));
    }

    public static Goal webRetargetingGoalToCore(WebRetargetingGoal webRetargetingGoal) {
        return webRetargetingGoal == null ? null : (Goal) new Goal()
                .withId(webRetargetingGoal.getId())
                .withType(webRetargetingGoal.getGoalType())
                .withTime(webRetargetingGoal.getTime());
    }

}
