package ru.yandex.direct.web.entity.adgroup.converter;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nullable;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.adgroup.container.ComplexAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexTextAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.TextAdGroup;
import ru.yandex.direct.web.entity.adgroup.model.WebTextAdGroup;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.web.entity.adgroup.converter.AdGroupBidModifiersConverter.webAdGroupBidModifiersToCore;
import static ru.yandex.direct.web.entity.adgroup.converter.AdGroupConverterUtils.convertGeo;
import static ru.yandex.direct.web.entity.adgroup.converter.AdGroupConverterUtils.convertTags;
import static ru.yandex.direct.web.entity.adgroup.converter.RelevanceMatchConverter.webRelevanceMatchesToCore;
import static ru.yandex.direct.web.entity.adgroup.converter.RetargetingConverter.webRetargetingsToCore;
import static ru.yandex.direct.web.entity.banner.converter.BannerConverter.webBannersToCoreComplexBanners;
import static ru.yandex.direct.web.entity.keyword.converter.KeywordConverter.webKeywordsToCoreKeywords;

public class TextAdGroupConverter {

    private TextAdGroupConverter() {
    }

    public static List<ComplexTextAdGroup> webAdGroupsToCoreComplexTextAdGroups(@Nullable List<WebTextAdGroup> webTextAdGroups,
                                                                                long overridingCampaignId) {
        List<ComplexTextAdGroup> complexAdGroups =
                mapList(webTextAdGroups, TextAdGroupConverter::webAdGroupToCoreComplexAdGroup);

        if (complexAdGroups != null) {
            StreamEx.of(complexAdGroups)
                    .nonNull()
                    .map(ComplexAdGroup::getAdGroup)
                    .nonNull()
                    .forEach(adGroup -> adGroup.withCampaignId(overridingCampaignId));
        }

        return complexAdGroups;
    }

    public static List<ComplexTextAdGroup> webAdGroupsToCoreComplexTextAdGroups(
            @Nullable List<WebTextAdGroup> webTextAdGroups) {
        return mapList(webTextAdGroups, TextAdGroupConverter::webAdGroupToCoreComplexAdGroup);
    }

    public static ComplexTextAdGroup webAdGroupToCoreComplexAdGroup(@Nullable WebTextAdGroup webTextAdGroup) {
        return webTextAdGroup == null ? null : new ComplexTextAdGroup()
                .withAdGroup(webAdGroupToCoreAdGroup(webTextAdGroup))
                .withKeywords(webKeywordsToCoreKeywords(webTextAdGroup.getKeywords()))
                .withRelevanceMatches(webRelevanceMatchesToCore(webTextAdGroup.getRelevanceMatches()))
                .withTargetInterests(webRetargetingsToCore(webTextAdGroup.getRetargetings()))
                .withComplexBidModifier(webAdGroupBidModifiersToCore(webTextAdGroup.getBidModifiers()))
                .withComplexBanners(webBannersToCoreComplexBanners(webTextAdGroup.getBanners()));
    }

    private static AdGroup webAdGroupToCoreAdGroup(@Nullable WebTextAdGroup webTextAdGroup) {
        if (webTextAdGroup == null) {
            return null;
        }
        List<String> minusKeywords = webTextAdGroup.getMinusKeywords() != null ?
                webTextAdGroup.getMinusKeywords() : new ArrayList<>();
        return new TextAdGroup()
                .withId(webTextAdGroup.getId())
                .withCampaignId(webTextAdGroup.getCampaignId())
                .withType(AdGroupType.BASE)
                .withName(webTextAdGroup.getName())
                .withMinusKeywords(minusKeywords)
                .withGeo(convertGeo(webTextAdGroup.getGeo()))
                .withTags(convertTags(webTextAdGroup.getTags()))
                .withPageGroupTags(webTextAdGroup.getPageGroupTags())
                .withTargetTags(webTextAdGroup.getTargetTags());
    }
}
