package ru.yandex.direct.web.entity.adgroup.converter;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.adgroup.model.AdShowType;
import ru.yandex.direct.core.entity.adgroup.model.UsersSegment;
import ru.yandex.direct.web.entity.adgroup.model.WebCpmAdGroup;
import ru.yandex.direct.web.entity.adgroup.model.WebVideoGoal;

public class WebVideoGoalConverter {

    private WebVideoGoalConverter() {
        // no instantiation
    }

    public static List<UsersSegment> webVideoGoalsToCoreUsersSegments(@Nullable List<WebVideoGoal> webVideoGoals,
                                                                      @Nonnull WebCpmAdGroup webCpmAdGroup) {
        if (webVideoGoals == null) {
            return null;
        }
        return webVideoGoals.stream().map(webVideoGoal -> webVideoGoalToCoreUsersSegment(webVideoGoal, webCpmAdGroup))
                .collect(Collectors.toList());
    }

    private static UsersSegment webVideoGoalToCoreUsersSegment(@Nullable WebVideoGoal webVideoGoal,
                                                               WebCpmAdGroup webCpmAdGroup) {
        if (webVideoGoal == null) {
            return null;
        }

        return new UsersSegment()
                .withType(AdShowType.fromSource(webVideoGoal.getType()))
                .withAdGroupId(webCpmAdGroup.getId());
    }
}
