package ru.yandex.direct.web.entity.adgroup.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.web.entity.bidmodifier.model.WebDemographicsBidModifier;
import ru.yandex.direct.web.entity.bidmodifier.model.WebDesktopBidModifier;
import ru.yandex.direct.web.entity.bidmodifier.model.WebDesktopOnlyBidModifier;
import ru.yandex.direct.web.entity.bidmodifier.model.WebExpressionBidModifier;
import ru.yandex.direct.web.entity.bidmodifier.model.WebMobileBidModifier;
import ru.yandex.direct.web.entity.bidmodifier.model.WebRetargetingBidModifier;
import ru.yandex.direct.web.entity.bidmodifier.model.WebSmartTVBidModifier;
import ru.yandex.direct.web.entity.bidmodifier.model.WebTabletBidModifier;
import ru.yandex.direct.web.entity.bidmodifier.model.WebVideoBidModifier;
import ru.yandex.direct.web.entity.bidmodifier.model.WebWeatherBidModifier;

public class WebAdGroupBidModifiers {

    public static class Prop {
        private Prop() {
        }

        public static final String RETARGETING_BID_MODIFIER = "retargeting_multiplier";
        public static final String DEMOGRAPHICS_BID_MODIFIER = "demography_multiplier";
        public static final String MOBILE_BID_MODIFIER = "mobile_multiplier";
        public static final String DESKTOP_BID_MODIFIER = "desktop_multiplier";
        public static final String TABLET_BID_MODIFIER = "tablet_multiplier";
        public static final String DESKTOP_ONLY_BID_MODIFIER = "desktop_only_multiplier";
        public static final String SMARTTV_BID_MODIFIER = "smarttv_multiplier";
        public static final String VIDEO_BID_MODIFIER = "video_multiplier";
        public static final String WEATHER_BID_MODIFIER = "weather_multiplier";
        public static final String EXPRESSION_BID_MODIFIERS = "expression_multipliers";
    }

    @JsonProperty(Prop.RETARGETING_BID_MODIFIER)
    private WebRetargetingBidModifier retargetingBidModifier;

    @JsonProperty(Prop.DEMOGRAPHICS_BID_MODIFIER)
    private WebDemographicsBidModifier demographicsBidModifier;

    @JsonProperty(Prop.MOBILE_BID_MODIFIER)
    private WebMobileBidModifier mobileBidModifier;

    @JsonProperty(Prop.DESKTOP_BID_MODIFIER)
    private WebDesktopBidModifier desktopBidModifier;

    @JsonProperty(Prop.TABLET_BID_MODIFIER)
    private WebTabletBidModifier tabletBidModifier;

    @JsonProperty(Prop.DESKTOP_ONLY_BID_MODIFIER)
    private WebDesktopOnlyBidModifier desktopOnlyBidModifier;

    @JsonProperty(Prop.SMARTTV_BID_MODIFIER)
    private WebSmartTVBidModifier smartTVBidModifier;

    @JsonProperty(Prop.VIDEO_BID_MODIFIER)
    private WebVideoBidModifier videoBidModifier;

    @JsonProperty(Prop.WEATHER_BID_MODIFIER)
    private WebWeatherBidModifier weatherBidModifier;

    @JsonProperty(Prop.EXPRESSION_BID_MODIFIERS)
    private List<WebExpressionBidModifier> expressionBidModifiers;

    public WebRetargetingBidModifier getRetargetingBidModifier() {
        return retargetingBidModifier;
    }

    public WebAdGroupBidModifiers withRetargetingBidModifier(
            WebRetargetingBidModifier webRetargetingBidModifier) {
        this.retargetingBidModifier = webRetargetingBidModifier;
        return this;
    }

    public WebDemographicsBidModifier getDemographicsBidModifier() {
        return demographicsBidModifier;
    }

    public WebAdGroupBidModifiers withDemographicsBidModifier(
            WebDemographicsBidModifier webDemographicsBidModifier) {
        this.demographicsBidModifier = webDemographicsBidModifier;
        return this;
    }

    public WebMobileBidModifier getMobileBidModifier() {
        return mobileBidModifier;
    }

    public WebAdGroupBidModifiers withMobileBidModifier(
            WebMobileBidModifier webMobileBidModifier) {
        this.mobileBidModifier = webMobileBidModifier;
        return this;
    }

    public WebDesktopBidModifier getDesktopBidModifier() {
        return desktopBidModifier;
    }

    public WebAdGroupBidModifiers withDesktopBidModifier(
            WebDesktopBidModifier webDesktopBidModifier) {
        this.desktopBidModifier = webDesktopBidModifier;
        return this;
    }

    public WebTabletBidModifier getTabletBidModifier() {
        return tabletBidModifier;
    }

    public WebAdGroupBidModifiers withTabletBidModifier(
            WebTabletBidModifier webTabletBidModifier) {
        this.tabletBidModifier = webTabletBidModifier;
        return this;
    }

    public WebDesktopOnlyBidModifier getDesktopOnlyBidModifier() {
        return desktopOnlyBidModifier;
    }

    public WebAdGroupBidModifiers withDesktopOnlyBidModifier(
            WebDesktopOnlyBidModifier webDesktopOnlyBidModifier) {
        this.desktopOnlyBidModifier = webDesktopOnlyBidModifier;
        return this;
    }

    public WebSmartTVBidModifier getSmartTVBidModifier() {
        return smartTVBidModifier;
    }

    public WebAdGroupBidModifiers withSmartTVBidModifier(
            WebSmartTVBidModifier webSmartTVBidModifier) {
        this.smartTVBidModifier = webSmartTVBidModifier;
        return this;
    }

    public WebVideoBidModifier getVideoBidModifier() {
        return videoBidModifier;
    }

    public WebAdGroupBidModifiers withVideoBidModifier(
            WebVideoBidModifier webVideoBidModifier) {
        this.videoBidModifier = webVideoBidModifier;
        return this;
    }

    public WebWeatherBidModifier getWeatherBidModifier() {
        return weatherBidModifier;
    }

    public WebAdGroupBidModifiers withWeatherBidModifier(WebWeatherBidModifier weatherBidModifier) {
        this.weatherBidModifier = weatherBidModifier;
        return this;
    }

    public List<WebExpressionBidModifier> getExpressionBidModifiers() {
        return expressionBidModifiers;
    }

    public WebAdGroupBidModifiers withExpressionBidModifiers(List<WebExpressionBidModifier> expressionBidModifiers) {
        this.expressionBidModifiers = expressionBidModifiers;
        return this;
    }
}
