package ru.yandex.direct.web.entity.adgroup.model;

import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.web.entity.banner.model.WebContentPromotionBanner;
import ru.yandex.direct.web.entity.keyword.model.WebKeyword;

/**
 * Веб модель группы объявлений продвижения контента.
 */
public class WebContentPromotionAdGroup {

    public static class Prop {
        private Prop() {
        }

        public static final String ID = "adgroup_id";
        public static final String ADGROUP_CONTENT_TYPE = "adgroup_content_type";
        public static final String CAMPAIGN_ID = "cid";
        public static final String NAME = "group_name";
        public static final String MINUS_KEYWORDS = "minus_words";
        public static final String GEO = "geo";
        public static final String TAGS = "tags";
        public static final String PAGE_GROUP_TAGS = "page_group_tags";
        public static final String TARGET_TAGS = "target_tags";
        public static final String GENERAL_PRICE = "general_limit_price";
        public static final String KEYWORDS = "keywords";
        public static final String RELEVANCE_MATCHES = "relevance_match";
        public static final String BID_MODIFIERS = "hierarchical_multipliers";
        public static final String BANNERS = "banners";
    }

    @JsonProperty(Prop.ID)
    private Long id;

    @JsonProperty(Prop.ADGROUP_CONTENT_TYPE)
    @Nullable
    private WebContentPromotionAdGroupType adGroupContentType;

    @JsonProperty(Prop.CAMPAIGN_ID)
    private Long campaignId;

    @JsonProperty(Prop.NAME)
    private String name;

    @JsonProperty(Prop.MINUS_KEYWORDS)
    private List<String> minusKeywords;

    @JsonProperty(Prop.GEO)
    private String geo;

    @JsonProperty(Prop.TAGS)
    private Map<String, Integer> tags;

    @JsonProperty(Prop.PAGE_GROUP_TAGS)
    private List<String> pageGroupTags;

    @JsonProperty(Prop.TARGET_TAGS)
    private List<String> targetTags;

    @JsonProperty(Prop.GENERAL_PRICE)
    private Double generalPrice;

    @JsonProperty(Prop.KEYWORDS)
    private List<WebKeyword> keywords;

    @JsonProperty(Prop.RELEVANCE_MATCHES)
    private List<WebAdGroupRelevanceMatch> relevanceMatches;

    @JsonProperty(Prop.BID_MODIFIERS)
    private WebAdGroupBidModifiers bidModifiers;

    @JsonProperty(Prop.BANNERS)
    private List<WebContentPromotionBanner> banners;

    public Long getId() {
        return id;
    }

    public WebContentPromotionAdGroup withId(Long id) {
        this.id = id;
        return this;
    }

    @Nullable
    public WebContentPromotionAdGroupType getAdGroupContentType() {
        return adGroupContentType;
    }

    public WebContentPromotionAdGroup withAdGroupContentType(
            @Nullable WebContentPromotionAdGroupType adGroupContentType) {
        this.adGroupContentType = adGroupContentType;
        return this;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public WebContentPromotionAdGroup withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public String getName() {
        return name;
    }

    public WebContentPromotionAdGroup withName(String name) {
        this.name = name;
        return this;
    }

    public List<String> getMinusKeywords() {
        return minusKeywords;
    }

    public WebContentPromotionAdGroup withMinusKeywords(List<String> minusKeywords) {
        this.minusKeywords = minusKeywords;
        return this;
    }

    public String getGeo() {
        return geo;
    }

    public WebContentPromotionAdGroup withGeo(String geo) {
        this.geo = geo;
        return this;
    }

    public Map<String, Integer> getTags() {
        return tags;
    }

    public WebContentPromotionAdGroup withTags(Map<String, Integer> tags) {
        this.tags = tags;
        return this;
    }

    public List<String> getPageGroupTags() {
        return pageGroupTags;
    }

    public WebContentPromotionAdGroup withPageGroupTags(List<String> pageGroupTags) {
        this.pageGroupTags = pageGroupTags;
        return this;
    }

    public List<String> getTargetTags() {
        return targetTags;
    }

    public WebContentPromotionAdGroup withTargetTags(List<String> targetTags) {
        this.targetTags = targetTags;
        return this;
    }


    public Double getGeneralPrice() {
        return generalPrice;
    }

    public WebContentPromotionAdGroup withGeneralPrice(Double generalPrice) {
        this.generalPrice = generalPrice;
        return this;
    }

    public List<WebKeyword> getKeywords() {
        return keywords;
    }

    public WebContentPromotionAdGroup withKeywords(List<WebKeyword> keywords) {
        this.keywords = keywords;
        return this;
    }

    public List<WebAdGroupRelevanceMatch> getRelevanceMatches() {
        return relevanceMatches;
    }

    public WebContentPromotionAdGroup withRelevanceMatches(
            List<WebAdGroupRelevanceMatch> relevanceMatches) {
        this.relevanceMatches = relevanceMatches;
        return this;
    }

    public WebAdGroupBidModifiers getBidModifiers() {
        return bidModifiers;
    }

    public WebContentPromotionAdGroup withBidModifiers(WebAdGroupBidModifiers bidModifiers) {
        this.bidModifiers = bidModifiers;
        return this;
    }

    public List<WebContentPromotionBanner> getBanners() {
        return banners;
    }

    public WebContentPromotionAdGroup withBanners(List<WebContentPromotionBanner> banners) {
        this.banners = banners;
        return this;
    }
}
