package ru.yandex.direct.web.entity.adgroup.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdgroupType;

public enum WebContentPromotionAdGroupType {
    @JsonProperty("video")
    VIDEO,

    @JsonProperty("collection")
    COLLECTION;

    public static ContentPromotionAdgroupType toCoreValue(
            WebContentPromotionAdGroupType webContentPromotionAdGroupType) {
        switch (webContentPromotionAdGroupType) {
            case COLLECTION:
                return ContentPromotionAdgroupType.COLLECTION;
            case VIDEO:
            default:
                return ContentPromotionAdgroupType.VIDEO;
        }
    }
}
