package ru.yandex.direct.web.entity.adgroup.model;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.web.entity.banner.model.WebCpmBanner;
import ru.yandex.direct.web.entity.keyword.model.WebKeyword;

public class WebCpmAdGroup {
    public static class Prop {
        private Prop() {
        }

        public static final String ID = "adgroup_id";
        public static final String CPM_BANNERS_TYPE = "cpm_banners_type";
        public static final String NAME = "group_name";
        public static final String MINUS_KEYWORDS = "minus_words";
        public static final String GEO = "geo";
        public static final String TAGS = "tags";
        public static final String PAGE_GROUP_TAGS = "page_group_tags";
        public static final String TARGET_TAGS = "target_tags";
        public static final String PROJECT_PARAM_CONDITIONS = "project_param_conditions";
        public static final String KEYWORDS = "keywords";
        public static final String RETARGETINGS = "retargetings";
        public static final String BID_MODIFIERS = "hierarchical_multipliers";
        public static final String BANNERS = "banners";
        public static final String VIDEO_GOALS = "video_goals";
        public static final String AUTO_PRICE = "auto_price";
        public static final String PAGE_BLOCKS = "page_blocks";
    }

    @JsonProperty(Prop.ID)
    private Long id;

    private long campaignId;

    @JsonProperty(Prop.CPM_BANNERS_TYPE)
    private String cpmBannersType;

    @JsonProperty(Prop.NAME)
    private String name;

    @JsonProperty(Prop.MINUS_KEYWORDS)
    private List<String> minusKeywords;

    @JsonProperty(Prop.GEO)
    private String geo;

    @JsonProperty(Prop.TAGS)
    private Map<String, Integer> tags;

    @JsonProperty(Prop.PAGE_GROUP_TAGS)
    private List<String> pageGroupTags;

    @JsonProperty(Prop.TARGET_TAGS)
    private List<String> targetTags;

    @JsonProperty(Prop.PROJECT_PARAM_CONDITIONS)
    private List<Long> projectParamConditions;

    @JsonProperty(Prop.KEYWORDS)
    private List<WebKeyword> keywords;

    @JsonProperty(Prop.RETARGETINGS)
    private List<WebCpmAdGroupRetargeting> retargetings;

    @JsonProperty(Prop.BANNERS)
    private List<WebCpmBanner> banners;

    @JsonProperty(Prop.BID_MODIFIERS)
    private WebAdGroupBidModifiers bidModifiers;

    @JsonProperty(Prop.VIDEO_GOALS)
    private List<WebVideoGoal> videoGoals;

    @JsonProperty(Prop.AUTO_PRICE)
    private WebAutoPrice autoPrice;

    @JsonProperty(Prop.PAGE_BLOCKS)
    private List<WebPageBlock> pageBlocks;

    public Long getId() {
        return id;
    }

    public WebCpmAdGroup withId(Long id) {
        this.id = id;
        return this;
    }

    public long getCampaignId() {
        return campaignId;
    }

    public WebCpmAdGroup withCampaignId(long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public String getCpmBannersType() {
        return cpmBannersType;
    }

    public WebCpmAdGroup withCpmBannersType(String cpmBannersType) {
        this.cpmBannersType = cpmBannersType;
        return this;
    }

    public String getName() {
        return name;
    }

    public WebCpmAdGroup withName(String name) {
        this.name = name;
        return this;
    }

    public List<String> getMinusKeywords() {
        return minusKeywords;
    }

    public WebCpmAdGroup withMinusKeywords(List<String> minusKeywords) {
        this.minusKeywords = minusKeywords;
        return this;
    }

    public String getGeo() {
        return geo;
    }

    public WebCpmAdGroup withGeo(String geo) {
        this.geo = geo;
        return this;
    }

    public Map<String, Integer> getTags() {
        return tags;
    }

    public WebCpmAdGroup withTags(Map<String, Integer> tags) {
        this.tags = tags;
        return this;
    }

    public List<String> getPageGroupTags() {
        return pageGroupTags;
    }

    public WebCpmAdGroup withPageGroupTags(List<String> pageGroupTags) {
        this.pageGroupTags = pageGroupTags;
        return this;
    }

    public List<String> getTargetTags() {
        return targetTags;
    }

    public WebCpmAdGroup withTargetTags(List<String> targetTags) {
        this.targetTags = targetTags;
        return this;
    }

    public List<Long> getProjectParamConditions() {
        return projectParamConditions;
    }

    public WebCpmAdGroup setProjectParamConditions(List<Long> projectParamConditions) {
        this.projectParamConditions = projectParamConditions;
        return this;
    }

    public List<WebKeyword> getKeywords() {
        return keywords;
    }

    public WebCpmAdGroup withKeywords(List<WebKeyword> keywords) {
        this.keywords = keywords;
        return this;
    }

    public List<WebCpmAdGroupRetargeting> getRetargetings() {
        return retargetings;
    }

    public WebCpmAdGroup withRetargetings(List<WebCpmAdGroupRetargeting> retargetings) {
        this.retargetings = retargetings;
        return this;
    }

    public List<WebCpmBanner> getBanners() {
        return banners;
    }

    public WebCpmAdGroup withBanners(List<WebCpmBanner> banners) {
        this.banners = banners;
        return this;
    }

    public WebAdGroupBidModifiers getBidModifiers() {
        return bidModifiers;
    }

    public WebCpmAdGroup withBidModifiers(WebAdGroupBidModifiers bidModifiers) {
        this.bidModifiers = bidModifiers;
        return this;
    }

    public WebAutoPrice getAutoPrice() {
        return autoPrice;
    }

    public WebCpmAdGroup withAutoPrice(WebAutoPrice autoPrice) {
        this.autoPrice = autoPrice;
        return this;
    }

    public Double getGeneralPrice() {
        return autoPrice == null ? null : autoPrice.getGeneralPrice();
    }

    public WebCpmAdGroup withGeneralPrice(Double generalPrice) {
        if (autoPrice == null) {
            autoPrice = new WebAutoPrice();
        }
        autoPrice.withGeneralPrice(generalPrice);
        return this;
    }

    public WebCpmAdGroup withVideoGoals(
            final List<WebVideoGoal> videoGoals) {
        this.videoGoals = videoGoals;
        return this;
    }

    public List<WebVideoGoal> getVideoGoals() {
        return videoGoals;
    }

    public List<WebPageBlock> getPageBlocks() {
        return pageBlocks;
    }

    public WebCpmAdGroup withPageBlocks(List<WebPageBlock> pageBlocks) {
        this.pageBlocks = pageBlocks;
        return this;
    }
}
