package ru.yandex.direct.web.entity.adgroup.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.retargeting.model.ConditionType;

public class WebCpmAdGroupRetargeting extends WebAdGroupRetargeting {
    public static class Prop {
        private Prop() {
        }

        public static final String NAME = "condition_name";
        public static final String DESCRIPTION = "description";
        public static final String TYPE = "type";
        public static final String GROUPS = "groups";
        public static final String PRICE_CONTEXT = "price_context";
    }

    @JsonProperty(Prop.NAME)
    private String name;

    @JsonProperty(Prop.DESCRIPTION)
    private String description;

    @JsonProperty(Prop.TYPE)
    private ConditionType conditionType;

    @JsonProperty(Prop.GROUPS)
    private List<WebRetargetingRule> groups;

    @JsonProperty(Prop.PRICE_CONTEXT)
    private Double priceContext;

    @Override
    public WebCpmAdGroupRetargeting withId(Long id) {
        super.withId(id);
        return this;
    }

    @Override
    public WebCpmAdGroupRetargeting withRetargetingConditionId(Long retargetingConditionId) {
        super.withRetargetingConditionId(retargetingConditionId);
        return this;
    }

    public String getName() {
        return name;
    }

    public WebCpmAdGroupRetargeting withName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public WebCpmAdGroupRetargeting withDescription(String description) {
        this.description = description;
        return this;
    }

    public ConditionType getConditionType() {
        return conditionType;
    }

    public WebCpmAdGroupRetargeting withConditionType(ConditionType conditionType) {
        this.conditionType = conditionType;
        return this;
    }

    public List<WebRetargetingRule> getGroups() {
        return groups;
    }

    public WebCpmAdGroupRetargeting withGroups(List<WebRetargetingRule> groups) {
        this.groups = groups;
        return this;
    }

    public Double getPriceContext() {
        return priceContext;
    }

    public WebCpmAdGroupRetargeting withPriceContext(Double priceContext) {
        this.priceContext = priceContext;
        return this;
    }
}
