package ru.yandex.direct.web.entity.adgroup.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WebPageBlock {
    public static class Prop {
        private Prop() {
        }

        public static final String PAGE_ID = "page_id";
        public static final String IMP_ID = "imp_id";
    }

    @JsonProperty(Prop.PAGE_ID)
    private Long pageId;

    @JsonProperty(Prop.IMP_ID)
    private Long impId;

    public Long getPageId() {
        return pageId;
    }

    public WebPageBlock withPageId(Long pageId) {
        this.pageId = pageId;
        return this;
    }

    public Long getImpId() {
        return impId;
    }

    public WebPageBlock withImpId(Long impId) {
        this.impId = impId;
        return this;
    }
}
