package ru.yandex.direct.web.entity.adgroup.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.direct.core.entity.retargeting.model.GoalType;

public class WebRetargetingGoal {
    public static class Prop {
        private Prop() {
        }

        public static final String ID = "id";
        public static final String TYPE = "type";
        public static final String TIME = "time";
    }

    @JsonProperty(Prop.ID)
    private Long id;

    @ApiModelProperty(
            value = "Тип цели - goal, segment, ecommerce, audience, ab_segment, social_demo, family, interests, behaviors",
            name = "goalType",
            allowableValues = "goal, segment, ecommerce, audience, ab_segment, social_demo, family, interests, behaviors"
    )
    @JsonProperty(Prop.TYPE)
    private GoalType goalType;

    @JsonProperty(Prop.TIME)
    private Integer time;

    public Long getId() {
        return id;
    }

    public WebRetargetingGoal withId(Long id) {
        this.id = id;
        return this;
    }

    public GoalType getGoalType() {
        return goalType;
    }

    public WebRetargetingGoal withGoalType(GoalType goalType) {
        this.goalType = goalType;
        return this;
    }

    public Integer getTime() {
        return time;
    }

    public WebRetargetingGoal withTime(Integer time) {
        this.time = time;
        return this;
    }
}
