package ru.yandex.direct.web.entity.adgroup.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.direct.core.entity.retargeting.model.RuleType;
import ru.yandex.direct.web.core.model.retargeting.CryptaInterestTypeWeb;

public class WebRetargetingRule {
    public static class Prop {
        private Prop() {
        }

        public static final String TYPE = "type";
        public static final String INTEREST_TYPE = "interest_type";
        public static final String GOALS = "goals";
    }

    @ApiModelProperty(
            value = "Тип правила",
            name = "ruleType",
            allowableValues = "all, not, or"
    )
    @JsonProperty(Prop.TYPE)
    private RuleType ruleType;

    @JsonProperty(Prop.INTEREST_TYPE)
    private CryptaInterestTypeWeb interestType;

    @JsonProperty(Prop.GOALS)
    private List<WebRetargetingGoal> goals;

    public RuleType getRuleType() {
        return ruleType;
    }

    public WebRetargetingRule withRuleType(RuleType ruleType) {
        this.ruleType = ruleType;
        return this;
    }

    public CryptaInterestTypeWeb getInterestType() {
        return interestType;
    }

    public WebRetargetingRule withInterestType(CryptaInterestTypeWeb interestType) {
        this.interestType = interestType;
        return this;
    }

    public List<WebRetargetingGoal> getGoals() {
        return goals;
    }

    public WebRetargetingRule withGoals(List<WebRetargetingGoal> goals) {
        this.goals = goals;
        return this;
    }
}
