package ru.yandex.direct.web.entity.adgroup.model;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.web.entity.banner.model.WebBanner;
import ru.yandex.direct.web.entity.keyword.model.WebKeyword;

public class WebTextAdGroup {

    public static class Prop {
        private Prop() {
        }

        public static final String ID = "adgroup_id";
        public static final String CAMPAIGN_ID = "cid";
        public static final String NAME = "group_name";
        public static final String MINUS_KEYWORDS = "minus_words";
        public static final String GEO = "geo";
        public static final String TAGS = "tags";
        public static final String PAGE_GROUP_TAGS = "page_group_tags";
        public static final String TARGET_TAGS = "target_tags";
        public static final String GENERAL_PRICE = "general_limit_price";
        public static final String KEYWORDS = "keywords";
        public static final String RELEVANCE_MATCHES = "relevance_match";
        public static final String RETARGETINGS = "retargetings";
        public static final String BID_MODIFIERS = "hierarchical_multipliers";
        public static final String BANNERS = "banners";
    }

    @JsonProperty(Prop.ID)
    private Long id;

    @JsonProperty(Prop.CAMPAIGN_ID)
    private Long campaignId;

    @JsonProperty(Prop.NAME)
    private String name;

    @JsonProperty(Prop.MINUS_KEYWORDS)
    private List<String> minusKeywords;

    @JsonProperty(Prop.GEO)
    private String geo;

    @JsonProperty(Prop.TAGS)
    private Map<String, Integer> tags;

    @JsonProperty(Prop.PAGE_GROUP_TAGS)
    private List<String> pageGroupTags;

    @JsonProperty(Prop.TARGET_TAGS)
    private List<String> targetTags;

    @JsonProperty(Prop.GENERAL_PRICE)
    private Double generalPrice;

    @JsonProperty(Prop.KEYWORDS)
    private List<WebKeyword> keywords;

    @JsonProperty(Prop.RELEVANCE_MATCHES)
    private List<WebAdGroupRelevanceMatch> relevanceMatches;

    @JsonProperty(Prop.RETARGETINGS)
    private List<WebAdGroupRetargeting> retargetings;

    @JsonProperty(Prop.BID_MODIFIERS)
    private WebAdGroupBidModifiers bidModifiers;

    @JsonProperty(Prop.BANNERS)
    private List<WebBanner> banners;

    public Long getId() {
        return id;
    }

    public WebTextAdGroup withId(Long id) {
        this.id = id;
        return this;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public WebTextAdGroup withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public String getName() {
        return name;
    }

    public WebTextAdGroup withName(String name) {
        this.name = name;
        return this;
    }

    public List<String> getMinusKeywords() {
        return minusKeywords;
    }

    public WebTextAdGroup withMinusKeywords(List<String> minusKeywords) {
        this.minusKeywords = minusKeywords;
        return this;
    }

    public String getGeo() {
        return geo;
    }

    public WebTextAdGroup withGeo(String geo) {
        this.geo = geo;
        return this;
    }

    public Map<String, Integer> getTags() {
        return tags;
    }

    public WebTextAdGroup withTags(Map<String, Integer> tags) {
        this.tags = tags;
        return this;
    }

    public List<String> getPageGroupTags() {
        return pageGroupTags;
    }

    public WebTextAdGroup withPageGroupTags(List<String> pageGroupTags) {
        this.pageGroupTags = pageGroupTags;
        return this;
    }

    public List<String> getTargetTags() {
        return targetTags;
    }

    public WebTextAdGroup withTargetTags(List<String> targetTags) {
        this.targetTags = targetTags;
        return this;
    }

    public Double getGeneralPrice() {
        return generalPrice;
    }

    public WebTextAdGroup withGeneralPrice(Double generalPrice) {
        this.generalPrice = generalPrice;
        return this;
    }

    public List<WebKeyword> getKeywords() {
        return keywords;
    }

    public WebTextAdGroup withKeywords(List<WebKeyword> keywords) {
        this.keywords = keywords;
        return this;
    }

    public List<WebAdGroupRelevanceMatch> getRelevanceMatches() {
        return relevanceMatches;
    }

    public WebTextAdGroup withRelevanceMatches(
            List<WebAdGroupRelevanceMatch> relevanceMatches) {
        this.relevanceMatches = relevanceMatches;
        return this;
    }

    public List<WebAdGroupRetargeting> getRetargetings() {
        return retargetings;
    }

    public WebTextAdGroup withRetargetings(
            List<WebAdGroupRetargeting> retargetings) {
        this.retargetings = retargetings;
        return this;
    }

    public WebAdGroupBidModifiers getBidModifiers() {
        return bidModifiers;
    }

    public WebTextAdGroup withBidModifiers(WebAdGroupBidModifiers bidModifiers) {
        this.bidModifiers = bidModifiers;
        return this;
    }

    public List<WebBanner> getBanners() {
        return banners;
    }

    public WebTextAdGroup withBanners(List<WebBanner> banners) {
        this.banners = banners;
        return this;
    }
}
