package ru.yandex.direct.web.entity.adgroup.presentations;

import ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds;
import ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectTranslations;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.queryrec.model.Language;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.web.validation.kernel.TranslatableWebDefect;

import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.ADVERTISED_APP_LINK_IS_NOT_SET;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.AD_GROUP_DOES_NOT_CONTAIN_THIS_BANNER;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.AD_GROUP_DOES_NOT_CONTAIN_THIS_KEYWORD;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.AD_GROUP_DOES_NOT_CONTAIN_THIS_RELEVANCE_MATCH;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.AD_GROUP_NAME_CANT_BE_EMPTY;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.AD_GROUP_NAME_IS_NOT_SET;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.AD_GROUP_STATUS_ARCHIVED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.AD_GROUP_STATUS_STOPPED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.AD_GROUP_TYPE_NOT_SUPPORTED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.ARCHIVED_AD_GROUP_MODIFICATION;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.BID_MODIFIERS_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.BS_TAG_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.CONTENT_PROMOTION_ADGROUP_TYPE_CHANGED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.CONTENT_PROMOTION_DISTINCT_TYPE_FROM_EXISTING;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.CONTENT_PROMOTION_SEVERAL_TYPES_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.DEVICE_TARGETING_IS_NOT_SET;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.DYNAMIC_TEXT_DOMAIN_IS_NOT_SET;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.EITHER_KEYWORDS_OR_RETARGETINGS_ALLOWED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.EMPTY_CONTENT_CATEGORIES_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.ERRORS_WHILE_COPYING_ADGROUPS;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.FINISH_TIME_SHOULD_BE_GREATER_THAN_START_TIME;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.INCONSISTENT_AD_GROUP_TYPE;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.INCONSISTENT_AD_GROUP_TYPE_TO_CAMPAIGN_TYPE;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.INCONSISTENT_DYNAMIC_AD_GROUP_TYPE;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.INVALID_APP_LINK_FORMAT;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.INVALID_APP_STORE_URL;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.INVALID_DYNAMIC_TEXT_DOMAIN;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.INVALID_MIN_OS_VERSION;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.KEYWORDS_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.MINUS_KEYWORDS_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.MIN_OS_VERSION_IS_NOT_SET;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.MUST_NOT_CONTAIN_DUPLICATED_OBJECTS;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.NETWORK_TARGETING_IS_NOT_SET;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.NOT_ALLOWED_VALUE;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.NOT_FOUND;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.ONLY_ONE_DEFAULT_AD_GROUP_ALLOWED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.PRICE_SALES_AD_GROUP_NOT_ALLOWED_MOBILE_PLATFORMS_COMBINATION;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.PRICE_SALES_AD_GROUP_TYPE_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.PRICE_SALES_AD_GROUP_USE_NOT_ALLOWED_BID_MODIFIERS;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.PRICE_SALES_DISALLOWED_ADGROUP_TYPE;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.PRICE_SALES_DISALLOWED_AUDIENCE_SEGMENTS;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.PRICE_SALES_DISALLOWED_METRIKA_SEGMENTS;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.PRICE_SALES_INVALID_PRIORITY;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.RESTRICTED_REGIONS;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.STORE_URL_MUST_BE_SAME_AS_URL_IN_MOBILE_CONTENT_CAMPAIGN;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.STORE_URL_MUST_BE_SAME_FOR_ALL_GROUPS_IN_MOBILE_CONTENT_CAMPAIGN;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Gen.UNABLE_TO_DELETE;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.Geo.BAD_GEO;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds.ModelId.FEED_NOT_EXIST;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.defaultWebDefect;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.paramWebDefect;
import static ru.yandex.direct.web.validation.kernel.WebDefectPresentationProviders.webDefect;

public class AdGroupDefectPresentations {

    private AdGroupDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableWebDefect> adGroupDefectPresentationRegistry() {
        AdGroupDefectTranslations translations = AdGroupDefectTranslations.INSTANCE;
        return DefaultDefectPresentationRegistry.builder()
                .register(ARCHIVED_AD_GROUP_MODIFICATION,
                        webDefect(translations.cantEditArchivedAdGroup()))
                .register(BAD_GEO,
                        paramWebDefect(di -> inconsistentGeoByLanguage(di.getDefect().params().getLanguage(),
                                di.getDefect().params().getBannerId())))
                .register(INCONSISTENT_AD_GROUP_TYPE_TO_CAMPAIGN_TYPE,
                        webDefect(translations.inconsistentAdGroupTypeToCampaignType()))
                .register(AD_GROUP_DOES_NOT_CONTAIN_THIS_BANNER,
                        defaultWebDefect())
                .register(AdGroupDefectIds.Gen.UNSUPPORTED_GROUP_TYPE,
                        defaultWebDefect())
                .register(AdGroupDefectIds.Gen.MUST_BE_MUTUALLY_EXCLUSIVE,
                        defaultWebDefect())
                .register(AD_GROUP_DOES_NOT_CONTAIN_THIS_KEYWORD,
                        defaultWebDefect())
                .register(AD_GROUP_DOES_NOT_CONTAIN_THIS_RELEVANCE_MATCH,
                        defaultWebDefect())
                .register(AdGroupDefectIds.Number.TOO_MANY_BANNERS_IN_AD_GROUP,
                        defaultWebDefect())
                .register(AdGroupDefectIds.Number.MAX_ADGROUPS_IN_CAMPAIGN,
                        defaultWebDefect())
                .register(AD_GROUP_NAME_IS_NOT_SET,
                        defaultWebDefect())
                .register(AD_GROUP_NAME_CANT_BE_EMPTY,
                        defaultWebDefect())
                .register(AdGroupDefectIds.String.AD_GROUP_NAME_TOO_LONG,
                        defaultWebDefect())
                .register(ADVERTISED_APP_LINK_IS_NOT_SET,
                        defaultWebDefect())
                .register(FEED_NOT_EXIST,
                        defaultWebDefect())
                .register(INVALID_APP_LINK_FORMAT,
                        defaultWebDefect())
                .register(AdGroupDefectIds.AppStoreDomain.APP_STORE_IS_NOT_SUPPORTED,
                        defaultWebDefect())
                .register(INVALID_APP_STORE_URL,
                        defaultWebDefect())
                .register(MIN_OS_VERSION_IS_NOT_SET,
                        defaultWebDefect())
                .register(INVALID_MIN_OS_VERSION,
                        defaultWebDefect())
                .register(DEVICE_TARGETING_IS_NOT_SET,
                        defaultWebDefect())
                .register(NETWORK_TARGETING_IS_NOT_SET,
                        defaultWebDefect())
                .register(DYNAMIC_TEXT_DOMAIN_IS_NOT_SET,
                        defaultWebDefect())
                .register(INVALID_DYNAMIC_TEXT_DOMAIN,
                        defaultWebDefect())
                .register(NOT_FOUND, defaultWebDefect())
                .register(UNABLE_TO_DELETE, defaultWebDefect())
                .register(MUST_NOT_CONTAIN_DUPLICATED_OBJECTS,
                        defaultWebDefect())
                .register(AD_GROUP_TYPE_NOT_SUPPORTED,
                        defaultWebDefect())
                .register(INCONSISTENT_AD_GROUP_TYPE,
                        defaultWebDefect())
                .register(INCONSISTENT_DYNAMIC_AD_GROUP_TYPE,
                        defaultWebDefect())
                .register(EITHER_KEYWORDS_OR_RETARGETINGS_ALLOWED,
                        defaultWebDefect())
                .register(EMPTY_CONTENT_CATEGORIES_NOT_ALLOWED,
                        defaultWebDefect())
                .register(CONTENT_PROMOTION_SEVERAL_TYPES_NOT_ALLOWED,
                        webDefect(translations.contentPromotionSeveralTypesNotAllowed()))
                .register(CONTENT_PROMOTION_DISTINCT_TYPE_FROM_EXISTING,
                        webDefect(translations.contentPromotionDistinctTypeFromExisting()))
                .register(CONTENT_PROMOTION_ADGROUP_TYPE_CHANGED,
                        webDefect(translations.contentPromotionAdGroupTypeChanged()))
                .register(KEYWORDS_NOT_ALLOWED,
                        defaultWebDefect())
                .register(BID_MODIFIERS_NOT_ALLOWED,
                        defaultWebDefect())
                .register(MINUS_KEYWORDS_NOT_ALLOWED,
                        defaultWebDefect())
                .register(RESTRICTED_REGIONS,
                        defaultWebDefect())
                .register(STORE_URL_MUST_BE_SAME_FOR_ALL_GROUPS_IN_MOBILE_CONTENT_CAMPAIGN,
                        defaultWebDefect())
                .register(STORE_URL_MUST_BE_SAME_AS_URL_IN_MOBILE_CONTENT_CAMPAIGN,
                        defaultWebDefect())
                .register(NOT_ALLOWED_VALUE,
                        defaultWebDefect())
                .register(BS_TAG_NOT_ALLOWED,
                        defaultWebDefect())
                .register(FINISH_TIME_SHOULD_BE_GREATER_THAN_START_TIME,
                        defaultWebDefect())
                .register(ERRORS_WHILE_COPYING_ADGROUPS,
                        defaultWebDefect())
                .register(ONLY_ONE_DEFAULT_AD_GROUP_ALLOWED,
                        defaultWebDefect())
                .register(PRICE_SALES_DISALLOWED_ADGROUP_TYPE,
                        defaultWebDefect())
                .register(PRICE_SALES_DISALLOWED_METRIKA_SEGMENTS,
                        defaultWebDefect())
                .register(PRICE_SALES_DISALLOWED_AUDIENCE_SEGMENTS,
                        defaultWebDefect())
                .register(PRICE_SALES_AD_GROUP_TYPE_NOT_ALLOWED,
                        defaultWebDefect())
                .register(PRICE_SALES_INVALID_PRIORITY,
                        defaultWebDefect())
                .register(PRICE_SALES_AD_GROUP_USE_NOT_ALLOWED_BID_MODIFIERS,
                        defaultWebDefect())
                .register(PRICE_SALES_AD_GROUP_NOT_ALLOWED_MOBILE_PLATFORMS_COMBINATION,
                        defaultWebDefect())
                .register(AD_GROUP_STATUS_ARCHIVED,
                        defaultWebDefect())
                .register(AD_GROUP_STATUS_STOPPED,
                        defaultWebDefect())
                .register(AdGroupDefectIds.PriceSalesTargetingAmount.TOO_FEW_TARGETINGS,
                        defaultWebDefect())
                .register(AdGroupDefectIds.PriceSalesTargetingAmount.TOO_MANY_TARGETINGS,
                        defaultWebDefect())
                .register(AdGroupDefectIds.Banners.REQUIRED_AGE_VARIABLE,
                        defaultWebDefect())
                .build();
    }

    private static Translatable inconsistentGeoByLanguage(Language language, Long bannerId) {
        switch (language) {
            case UKRAINIAN:
                return AdGroupDefectTranslations.INSTANCE.badGeoDetailedInconsistentGeoWithUkrainianLanguage(
                        new Identity(bannerId));
            case KAZAKH:
                return AdGroupDefectTranslations.INSTANCE.badGeoDetailedInconsistentGeoWithKazakhLanguage(
                        new Identity(bannerId));
            case TURKISH:
                return AdGroupDefectTranslations.INSTANCE.badGeoDetailedInconsistentGeoWithTurkishLanguage(
                        new Identity(bannerId));
            case BELARUSIAN:
                return AdGroupDefectTranslations.INSTANCE.badGeoDetailedInconsistentGeoWithBelarussianLanguage(
                        new Identity(bannerId));

            default:
                throw new IllegalStateException("Unknown language with geo compatibility.");
        }
    }
}
