package ru.yandex.direct.web.entity.adgroup.presentations;

import ru.yandex.direct.core.entity.adgroup.container.ComplexContentPromotionAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexCpmAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexTextAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.relevancematch.model.RelevanceMatch;
import ru.yandex.direct.core.entity.retargeting.model.Retargeting;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.validation.result.MappingPathNodeConverter;
import ru.yandex.direct.web.entity.adgroup.model.WebAdGroupRelevanceMatch;
import ru.yandex.direct.web.entity.adgroup.model.WebAdGroupRetargeting;
import ru.yandex.direct.web.entity.adgroup.model.WebContentPromotionAdGroup;
import ru.yandex.direct.web.entity.adgroup.model.WebCpmAdGroup;
import ru.yandex.direct.web.entity.adgroup.model.WebCpmAdGroupRetargeting;
import ru.yandex.direct.web.entity.adgroup.model.WebTextAdGroup;
import ru.yandex.direct.web.entity.relevancematch.presentation.RelevanceMatchPathConverters;

public class AdGroupPathConverters {

    private AdGroupPathConverters() {
    }

    public static final MappingPathNodeConverter TEXT_AD_GROUP_PATH_CONVERTER =
            MappingPathNodeConverter.builder(AdGroupPathConverters.class.getName())
                    .replace(AdGroup.ID.name(), WebTextAdGroup.Prop.ID)
                    .replace(AdGroup.TYPE.name(), "type")
                    .replace(AdGroup.CAMPAIGN_ID.name(), WebTextAdGroup.Prop.CAMPAIGN_ID)
                    .replace(AdGroup.NAME.name(), WebTextAdGroup.Prop.NAME)
                    .replace(AdGroup.MINUS_KEYWORDS.name(), WebTextAdGroup.Prop.MINUS_KEYWORDS)
                    .replace(AdGroup.GEO.name(), WebTextAdGroup.Prop.GEO)
                    .replace(AdGroup.TAGS.name(), WebTextAdGroup.Prop.TAGS)

                    .replace(ComplexTextAdGroup.KEYWORDS.name(), WebTextAdGroup.Prop.KEYWORDS)
                    .replace(ComplexTextAdGroup.RELEVANCE_MATCHES.name(), WebTextAdGroup.Prop.RELEVANCE_MATCHES)
                    .replace(ComplexTextAdGroup.COMPLEX_BANNERS.name(), WebTextAdGroup.Prop.BANNERS)
                    .replace(ComplexTextAdGroup.COMPLEX_BID_MODIFIER.name(), WebTextAdGroup.Prop.BID_MODIFIERS)
                    .replace(ComplexTextAdGroup.TARGET_INTERESTS.name(), WebTextAdGroup.Prop.RETARGETINGS)
                    .build();

    public static final MappingPathNodeConverter CPM_AD_GROUP_PATH_CONVERTER =
            MappingPathNodeConverter.builder(AdGroupPathConverters.class.getName())
                    .replace(AdGroup.ID.name(), WebCpmAdGroup.Prop.ID)
                    .replace(AdGroup.TYPE.name(), "type")
                    .replace(AdGroup.NAME.name(), WebCpmAdGroup.Prop.NAME)
                    .replace(AdGroup.MINUS_KEYWORDS.name(), WebCpmAdGroup.Prop.MINUS_KEYWORDS)
                    .replace(AdGroup.GEO.name(), WebCpmAdGroup.Prop.GEO)
                    .replace(AdGroup.TAGS.name(), WebCpmAdGroup.Prop.TAGS)

                    .replace(ComplexCpmAdGroup.KEYWORDS.name(), WebCpmAdGroup.Prop.KEYWORDS)
                    .replace(ComplexCpmAdGroup.BANNERS.name(), WebCpmAdGroup.Prop.BANNERS)
                    .replace(ComplexCpmAdGroup.COMPLEX_BID_MODIFIER.name(), WebCpmAdGroup.Prop.BID_MODIFIERS)
                    .replace(ComplexCpmAdGroup.TARGET_INTERESTS.name(), WebCpmAdGroup.Prop.RETARGETINGS)
                    .replace(ComplexCpmAdGroup.RETARGETING_CONDITIONS.name(), WebCpmAdGroup.Prop.RETARGETINGS)
                    .build();

    public static final MappingPathNodeConverter CONTENT_PROMOTION_VIDEO_ADGROUP_PATH_CONVERTER =
            MappingPathNodeConverter.builder(AdGroupPathConverters.class.getName())
                    .replace(AdGroup.ID.name(), WebContentPromotionAdGroup.Prop.ID)
                    .replace(AdGroup.TYPE.name(), "type")
                    .replace(AdGroup.NAME.name(), WebContentPromotionAdGroup.Prop.NAME)
                    .replace(AdGroup.MINUS_KEYWORDS.name(), WebContentPromotionAdGroup.Prop.MINUS_KEYWORDS)
                    .replace(AdGroup.GEO.name(), WebContentPromotionAdGroup.Prop.GEO)
                    .replace(AdGroup.TAGS.name(), WebContentPromotionAdGroup.Prop.TAGS)

                    .replace(ComplexContentPromotionAdGroup.KEYWORDS.name(), WebContentPromotionAdGroup.Prop.KEYWORDS)
                    .replace(ComplexContentPromotionAdGroup.RELEVANCE_MATCHES.name(), WebContentPromotionAdGroup.Prop.RELEVANCE_MATCHES)
                    .replace(ComplexContentPromotionAdGroup.BANNERS.name(), WebContentPromotionAdGroup.Prop.BANNERS)
                    .replace(ComplexContentPromotionAdGroup.COMPLEX_BID_MODIFIER.name(), WebContentPromotionAdGroup.Prop.BID_MODIFIERS)
                    .build();

    public static final MappingPathNodeConverter CPM_AD_GROUP_RETARGETING_PATH_CONVERTER =
            MappingPathNodeConverter.builder(AdGroupPathConverters.class.getName())
                    .replace(Retargeting.ID.name(), WebAdGroupRetargeting.Prop.ID)
                    .replace(Retargeting.RETARGETING_CONDITION_ID.name(), WebAdGroupRetargeting.Prop.RET_COND_ID)
                    .replace(Retargeting.PRICE_CONTEXT.name(), WebCpmAdGroupRetargeting.Prop.PRICE_CONTEXT)
                    .replace(RetargetingCondition.NAME.name(), WebCpmAdGroupRetargeting.Prop.NAME)
                    .replace(RetargetingCondition.DESCRIPTION.name(), WebCpmAdGroupRetargeting.Prop.DESCRIPTION)
                    .replace(RetargetingCondition.TYPE.name(), WebCpmAdGroupRetargeting.Prop.TYPE)
                    .replace(RetargetingCondition.RULES.name(), WebCpmAdGroupRetargeting.Prop.GROUPS)
                    .build();

    public static final MappingPathNodeConverter AD_GROUP_RETARGETING_PATH_CONVERTER =
            MappingPathNodeConverter.builder(AdGroupPathConverters.class.getName())
                    .replace(Retargeting.ID.name(), WebAdGroupRetargeting.Prop.ID)
                    .replace(Retargeting.RETARGETING_CONDITION_ID.name(), WebAdGroupRetargeting.Prop.RET_COND_ID)
                    .build();

    public static final MappingPathNodeConverter AD_GROUP_RELEVANCE_MATCH_PATH_CONVERTER =
            MappingPathNodeConverter.builder(RelevanceMatchPathConverters.class.getName())
                    .replace(RelevanceMatch.ID.name(), WebAdGroupRelevanceMatch.Prop.ID)
                    .replace(RelevanceMatch.PRICE.name(), "price")
                    .replace(RelevanceMatch.PRICE_CONTEXT.name(), "price_context")
                    .replace(RelevanceMatch.AUTOBUDGET_PRIORITY.name(), "autobudget_priority")
                    .replace(RelevanceMatch.IS_SUSPENDED.name(), "is_suspended")
                    .build();
}
