package ru.yandex.direct.web.entity.adgroup.service.text;

import java.math.BigDecimal;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.bids.validation.PriceValidator;
import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.web.entity.adgroup.model.WebTextAdGroup;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@ParametersAreNonnullByDefault
@Service
public class WebTextAdGroupValidationService {

    @Autowired
    public WebTextAdGroupValidationService() {
    }

    public ValidationResult<List<WebTextAdGroup>, Defect> validate(List<WebTextAdGroup> webTextAdGroups,
                                                                   Currency clientCurrency, AdGroupType adGroupType) {
        return ListValidationBuilder.of(webTextAdGroups, Defect.class)
                .checkEach(notNull())
                .checkEachBy(webAdGroup -> validateWebAdGroup(webAdGroup, clientCurrency, adGroupType))
                .getResult();
    }

    private ValidationResult<WebTextAdGroup, Defect> validateWebAdGroup(WebTextAdGroup webTextAdGroup,
                                                                        Currency clientCurrency, AdGroupType adGroupType) {
        ItemValidationBuilder<WebTextAdGroup, Defect> vb = ItemValidationBuilder.of(webTextAdGroup, Defect.class);

        if (webTextAdGroup.getGeneralPrice() != null) {
            vb.item(BigDecimal.valueOf(webTextAdGroup.getGeneralPrice()), WebTextAdGroup.Prop.GENERAL_PRICE)
                    .checkBy(new PriceValidator(clientCurrency, adGroupType));
        }

        return vb.getResult();
    }
}
