package ru.yandex.direct.web.entity.agency.controller;


import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;
import ru.yandex.direct.rbac.RbacRole;
import ru.yandex.direct.web.annotations.AllowedOperatorRoles;
import ru.yandex.direct.web.annotations.AllowedSubjectRoles;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.entity.agency.model.GetSubLoginsResponse;
import ru.yandex.direct.web.entity.agency.service.WebAgencyService;

import static ru.yandex.direct.web.core.security.authentication.DirectCookieAuthProvider.PARAMETER_ULOGIN;


@Controller
@RequestMapping(value = "/agency",
        produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(tags = "agency")
public class AgencyController {
    private final WebAgencyService webAgencyService;

    public AgencyController(WebAgencyService webAgencyService) {
        this.webAgencyService = webAgencyService;
    }

    @ApiOperation(
            value = "searchAgencySubClientsForDeals",
            httpMethod = "POST",
            nickname = "searchAgencySubClientsForDeals"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = GetSubLoginsResponse.class)
            }
    )
    @PreAuthorizeWrite
    @RequestMapping(path = "/search_sub_clients_for_deals", method = RequestMethod.POST)
    @ResponseBody
    @AllowedSubjectRoles(RbacRole.AGENCY)
    @AllowedOperatorRoles({RbacRole.SUPER, RbacRole.SUPERREADER, RbacRole.AGENCY})
    public WebResponse searchAgencySubClientsForDeals(
            @SuppressWarnings("unused") @RequestParam(value = PARAMETER_ULOGIN, required = false) @ApiParam(example =
                    "agency login") String subjectLogin) {
        return webAgencyService.searchAgencySubClientsForDeals();
    }

}
