package ru.yandex.direct.web.entity.agency.service;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.agency.service.AgencyService;
import ru.yandex.direct.core.entity.campaign.model.CampaignSimple;
import ru.yandex.direct.core.entity.deal.service.DealService;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.core.security.DirectWebAuthenticationSource;
import ru.yandex.direct.web.entity.agency.model.GetSubLoginsResponse;

import static java.util.Collections.emptyList;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;

@Service
public class WebAgencyService {

    private final DirectWebAuthenticationSource directWebAuthenticationSource;
    private final AgencyService agencyService;
    private final DealService dealService;
    private final ShardHelper shardHelper;
    private static final long MAX_SUB_CLIENTS = 1000;

    @Autowired
    public WebAgencyService(
            DirectWebAuthenticationSource directWebAuthenticationSource,
            AgencyService agencyService, DealService dealService, ShardHelper shardHelper) {
        this.directWebAuthenticationSource = directWebAuthenticationSource;
        this.agencyService = agencyService;
        this.dealService = dealService;
        this.shardHelper = shardHelper;
    }

    public WebResponse searchAgencySubClientsForDeals() {
        Long chiefUid = directWebAuthenticationSource.getAuthentication().getSubjectUser().getChiefUid();
        List<String> logins = agencyService.getSubClientLogins(chiefUid, MAX_SUB_CLIENTS, "");
        Map<String, Long> clientIdsByLogins = shardHelper.getClientIdsByLogins(logins);
        Map<Long, List<CampaignSimple>> campaignsByClientIds =
                dealService.searchDealCampaignsByClientIds(clientIdsByLogins.values());
        Predicate<String> loginHasCampaignForDeals =
                login -> !campaignsByClientIds.getOrDefault(clientIdsByLogins.get(login), emptyList()).isEmpty();
        List<String> loginsWithCampaignsForDeals = filterList(logins, loginHasCampaignForDeals);
        return new GetSubLoginsResponse().withResult(loginsWithCampaignsForDeals);
    }

}
