package ru.yandex.direct.web.entity.agencyofflinereport;

import java.util.function.Function;

import com.google.common.net.HttpHeaders;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;

import ru.yandex.direct.asynchttp.AbstractParsableRequest;

public class S3FileResponseParser extends AbstractParsableRequest<ContentWithTypeAndDisposition> {
    public S3FileResponseParser(long id, Request request) {
        super(id, request);
    }

    @Override
    public Function<Response, ContentWithTypeAndDisposition> getParseFunction() {
        return response -> new ContentWithTypeAndDisposition(
                response.getResponseBodyAsBytes(),
                response.getHeader(HttpHeaders.CONTENT_TYPE),
                response.getHeader(HttpHeaders.CONTENT_DISPOSITION)
        );
    }
}
